package com.googlecode.gendevcode.service;

import java.util.List;
import java.util.Map;

import org.w3c.dom.Document;

import com.googlecode.gendevcode.model.pdm.TablePdmXml;
import com.googlecode.gendevcode.model.pdm.ViewPdmXml;
import com.googlecode.gendevcode.service.basic.BaseService;

/**
 * 读取PDM文件接口类
 * @author devilishking
 *
 */
public interface PdmService extends BaseService {
	/**
	 * 获取表和视图的关联关系
	 * @param viewList	             视图列表<视图信息>
	 * @param viewMap	             视图集合<视图编号, 视图信息>
	 * @param tableIdListMap 表和视图的关联关系集合<视图编号, List<表编号>>
	 * @param doc            文档视图
	 * @throws Exception
	 */
	public void setViewTabelId(List<ViewPdmXml> viewList, 
							   Map<String, ViewPdmXml> viewMap,
							   Map<String, List<String>> tableIdListMap, 
							   Document doc) throws Exception;
	/**
	 * 获取表信息
	 * @param tablePdmXmlMap 	        表信息集合<表编号, 表信息>
	 * @param tablePdmXmlByCodeMap 表信息集合<表编码, 表信息>
	 * @param viewList	                             视图列表<视图信息>
	 * @param tableIdListMap 	        表和视图的关联关系集合<视图编号, List<表编号>>
	 * @param doc 			  	        文档视图
	 * @throws Exception
	 */
	public void setTableInfo(Map<String, TablePdmXml> tablePdmXmlMap, 
							 Map<String, TablePdmXml> tablePdmXmlByCodeMap,
							 List<ViewPdmXml> viewList,
							 Map<String, List<String>> tableIdListMap,
							 Document doc) throws Exception;
}