package com.googlecode.gendevcode.service;

import java.util.List;

import com.googlecode.gendevcode.model.ProjectXml;
import com.googlecode.gendevcode.service.basic.BaseService;

/**
 * 项目设置接口类
 * @author devilishking
 *
 */
public interface ProjectConfigService extends BaseService {	
	/**
	 * 获取生成级别列表
	 * @return
	 * @throws Exception
	 */
	public List<String> getGenLevelList() throws Exception;

	/**
	 * 根据模块名称和生成级别获取待生成的文件路径
	 * @param packageCode 包名
	 * @param genLevel    生成级别
	 * @param projectXml  项目信息
	 * @return
	 * @throws Exception
	 */
	public String getGenFilePath(String packageCode, String genLevel, ProjectXml projectXml) throws Exception;
}