/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitCounter;
import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.ChunkIterator;
import com.googlecode.javaewah.ChunkIteratorImpl;
import com.googlecode.javaewah.ClearIntIterator;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.FastAggregation;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IntIteratorImpl;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah.NonEmptyVirtualStorage;
import com.googlecode.javaewah.ReverseEWAHIterator;
import com.googlecode.javaewah.ReverseIntIterator;
import com.googlecode.javaewah.RunningLengthWord;
import com.googlecode.javaewah.symmetric.RunningBitmapMerge;
import com.googlecode.javaewah.symmetric.ThresholdFuncBitmap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class EWAHCompressedBitmap
implements Cloneable,
Externalizable,
Iterable<Integer>,
BitmapStorage,
LogicalElement<EWAHCompressedBitmap> {
    private int actualSizeInWords = 1;
    protected long[] buffer = null;
    private RunningLengthWord rlw = null;
    protected int sizeInBits = 0;
    public static final int DEFAULT_BUFFER_SIZE = 4;
    public static final boolean ADJUST_CONTAINER_SIZE_WHEN_AGGREGATING = true;
    public static final int WORD_IN_BITS = 64;
    static final long serialVersionUID = 1L;

    public EWAHCompressedBitmap() {
        this(4);
    }

    public EWAHCompressedBitmap(int bufferSize) {
        this.buffer = new long[bufferSize];
        this.rlw = new RunningLengthWord(this, 0);
    }

    @Deprecated
    public void add(long newData) {
        this.addWord(newData);
    }

    @Deprecated
    public void add(long newData, int bitsThatMatter) {
        this.addWord(newData, bitsThatMatter);
    }

    @Override
    public void addWord(long newData) {
        this.addWord(newData, 64);
    }

    public void addWord(long newData, int bitsThatMatter) {
        this.sizeInBits += bitsThatMatter;
        if (newData == 0L) {
            this.addEmptyWord(false);
        } else if (newData == -1L) {
            this.addEmptyWord(true);
        } else {
            this.addLiteralWord(newData);
        }
    }

    private void addEmptyWord(boolean v) {
        boolean noLiteralWords = this.rlw.getNumberOfLiteralWords() == 0;
        long runningLength = this.rlw.getRunningLength();
        if (noLiteralWords && runningLength == 0L) {
            this.rlw.setRunningBit(v);
        }
        if (noLiteralWords && this.rlw.getRunningBit() == v && runningLength < 0xFFFFFFFFL) {
            this.rlw.setRunningLength(runningLength + 1L);
            return;
        }
        this.push_back(0L);
        this.rlw.position = this.actualSizeInWords - 1;
        this.rlw.setRunningBit(v);
        this.rlw.setRunningLength(1L);
    }

    private void addLiteralWord(long newData) {
        int numberSoFar = this.rlw.getNumberOfLiteralWords();
        if (numberSoFar >= Integer.MAX_VALUE) {
            this.push_back(0L);
            this.rlw.position = this.actualSizeInWords - 1;
            this.rlw.setNumberOfLiteralWords(1L);
            this.push_back(newData);
        }
        this.rlw.setNumberOfLiteralWords(numberSoFar + 1);
        this.push_back(newData);
    }

    @Override
    public void addStreamOfLiteralWords(long[] data, int start, int number) {
        int leftOverNumber = number;
        while (leftOverNumber > 0) {
            int numberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatWeCanAdd = leftOverNumber < Integer.MAX_VALUE - numberOfLiteralWords ? leftOverNumber : Integer.MAX_VALUE - numberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(numberOfLiteralWords + whatWeCanAdd);
            this.push_back(data, start, whatWeCanAdd);
            this.sizeInBits += whatWeCanAdd * 64;
            if ((leftOverNumber -= whatWeCanAdd) <= 0) continue;
            this.push_back(0L);
            this.rlw.position = this.actualSizeInWords - 1;
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, long number) {
        if (number == 0L) {
            return;
        }
        this.sizeInBits = (int)((long)this.sizeInBits + number * 64L);
        this.fastaddStreamOfEmptyWords(v, number);
    }

    @Override
    public void addStreamOfNegatedLiteralWords(long[] data, int start, int number) {
        int leftOverNumber = number;
        while (leftOverNumber > 0) {
            int numberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatWeCanAdd = leftOverNumber < Integer.MAX_VALUE - numberOfLiteralWords ? leftOverNumber : Integer.MAX_VALUE - numberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(numberOfLiteralWords + whatWeCanAdd);
            this.negative_push_back(data, start, whatWeCanAdd);
            this.sizeInBits += whatWeCanAdd * 64;
            if ((leftOverNumber -= whatWeCanAdd) <= 0) continue;
            this.push_back(0L);
            this.rlw.position = this.actualSizeInWords - 1;
        }
    }

    @Override
    public EWAHCompressedBitmap and(EWAHCompressedBitmap a) {
        int size = this.actualSizeInWords > a.actualSizeInWords ? this.actualSizeInWords : a.actualSizeInWords;
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size);
        this.andToContainer(a, container);
        return container;
    }

    public void andToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        container.clear();
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else {
                    long index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.dischargeAsEmpty(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.andToContainer(a, counter);
        return counter.getCount();
    }

    @Override
    public EWAHCompressedBitmap andNot(EWAHCompressedBitmap a) {
        int size = this.actualSizeInWords > a.actualSizeInWords ? this.actualSizeInWords : a.actualSizeInWords;
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size);
        this.andNotToContainer(a, container);
        return container;
    }

    public void andNotToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        IteratingBufferedRunningLengthWord remaining;
        container.clear();
        EWAHIterator i = this.getEWAHIterator();
        EWAHIterator j = a.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                long index;
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit() && i_is_prey || !predator.getRunningBit() && !i_is_prey) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else if (i_is_prey) {
                    index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                } else {
                    index = prey.dischargeNegated(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) & (rlwj.getLiteralWordAt(k) ^ 0xFFFFFFFFFFFFFFFFL));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = remaining = i_remains ? rlwi : rlwj;
        if (i_remains) {
            remaining.discharge(container);
        } else {
            remaining.dischargeAsEmpty(container);
        }
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andNotCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.andNotToContainer(a, counter);
        return counter.getCount();
    }

    public int cardinality() {
        int counter = 0;
        EWAHIterator i = this.getEWAHIterator();
        while (i.hasNext()) {
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                counter = (int)((long)counter + 64L * localrlw.getRunningLength());
            }
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                counter += Long.bitCount(i.buffer()[i.literalWords() + j]);
            }
        }
        return counter;
    }

    @Override
    public void clear() {
        this.sizeInBits = 0;
        this.actualSizeInWords = 1;
        this.rlw.position = 0;
        this.buffer[0] = 0L;
    }

    public EWAHCompressedBitmap clone() {
        EWAHCompressedBitmap clone = null;
        try {
            clone = (EWAHCompressedBitmap)super.clone();
            clone.buffer = (long[])this.buffer.clone();
            clone.actualSizeInWords = this.actualSizeInWords;
            clone.sizeInBits = this.sizeInBits;
            clone.rlw = new RunningLengthWord(clone, this.rlw.position);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public void deserialize(DataInput in) throws IOException {
        this.sizeInBits = in.readInt();
        this.actualSizeInWords = in.readInt();
        if (this.buffer.length < this.actualSizeInWords) {
            this.buffer = new long[this.actualSizeInWords];
        }
        for (int k = 0; k < this.actualSizeInWords; ++k) {
            this.buffer[k] = in.readLong();
        }
        this.rlw = new RunningLengthWord(this, in.readInt());
    }

    public boolean equals(Object o) {
        if (o instanceof EWAHCompressedBitmap) {
            try {
                this.xorToContainer((EWAHCompressedBitmap)o, new NonEmptyVirtualStorage());
                return true;
            }
            catch (NonEmptyVirtualStorage.NonEmptyException e) {
                return false;
            }
        }
        return false;
    }

    private void fastaddStreamOfEmptyWords(boolean v, long number) {
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0L) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0L);
            this.rlw.position = this.actualSizeInWords - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
        }
        long runLen = this.rlw.getRunningLength();
        long whatWeCanAdd = number < 0xFFFFFFFFL - runLen ? number : 0xFFFFFFFFL - runLen;
        this.rlw.setRunningLength(runLen + whatWeCanAdd);
        number -= whatWeCanAdd;
        while (number >= 0xFFFFFFFFL) {
            this.push_back(0L);
            this.rlw.position = this.actualSizeInWords - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(0xFFFFFFFFL);
            number -= 0xFFFFFFFFL;
        }
        if (number > 0L) {
            this.push_back(0L);
            this.rlw.position = this.actualSizeInWords - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(number);
        }
    }

    public EWAHIterator getEWAHIterator() {
        return new EWAHIterator(this, this.actualSizeInWords);
    }

    private ReverseEWAHIterator getReverseEWAHIterator() {
        return new ReverseEWAHIterator(this, this.actualSizeInWords);
    }

    public IteratingRLW getIteratingRLW() {
        return new IteratingBufferedRunningLengthWord(this);
    }

    @Deprecated
    public List<Integer> getPositions() {
        return this.toList();
    }

    public List<Integer> toList() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        EWAHIterator i = this.getEWAHIterator();
        int pos = 0;
        while (i.hasNext()) {
            int j;
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                j = 0;
                while ((long)j < localrlw.getRunningLength()) {
                    for (int c = 0; c < 64; ++c) {
                        v.add(pos++);
                    }
                    ++j;
                }
            } else {
                pos = (int)((long)pos + 64L * localrlw.getRunningLength());
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                long T;
                for (long data = i.buffer()[i.literalWords() + j]; data != 0L; data ^= T) {
                    T = data & -data;
                    v.add(Long.bitCount(T - 1L) + pos);
                }
                pos += 64;
            }
        }
        while (v.size() > 0 && v.get(v.size() - 1) >= this.sizeInBits) {
            v.remove(v.size() - 1);
        }
        return v;
    }

    public int hashCode() {
        int karprabin = 0;
        int B = 31;
        EWAHIterator i = this.getEWAHIterator();
        while (i.hasNext()) {
            i.next();
            if (i.rlw.getRunningBit()) {
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (i.rlw.getRunningLength() & 0xFFFFFFFFL)));
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (i.rlw.getRunningLength() >>> 32)));
            }
            for (int k = 0; k < i.rlw.getNumberOfLiteralWords(); ++k) {
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (this.buffer[i.literalWords() + k] & 0xFFFFFFFFL)));
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (this.buffer[i.literalWords() + k] >>> 32)));
            }
        }
        return karprabin;
    }

    public boolean intersects(EWAHCompressedBitmap a) {
        NonEmptyVirtualStorage nevs = new NonEmptyVirtualStorage();
        try {
            this.andToContainer(a, nevs);
        }
        catch (NonEmptyVirtualStorage.NonEmptyException nee) {
            return true;
        }
        return false;
    }

    public IntIterator intIterator() {
        return new IntIteratorImpl(this.getEWAHIterator());
    }

    public IntIterator reverseIntIterator() {
        return new ReverseIntIterator(this.getReverseEWAHIterator(), this.sizeInBits);
    }

    public boolean isEmpty() {
        return this.getFirstSetBit() < 0;
    }

    public IntIterator clearIntIterator() {
        return new ClearIntIterator(this.getEWAHIterator(), this.sizeInBits);
    }

    public ChunkIterator chunkIterator() {
        return new ChunkIteratorImpl(this.getEWAHIterator(), this.sizeInBits);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = EWAHCompressedBitmap.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return this.under.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    private void negative_push_back(long[] data, int start, int number) {
        while (this.actualSizeInWords + number >= this.buffer.length) {
            long[] oldBuffer = this.buffer;
            this.buffer = this.actualSizeInWords + number < 32768 ? new long[(this.actualSizeInWords + number) * 2] : ((this.actualSizeInWords + number) * 3 / 2 < this.actualSizeInWords + number ? new long[Integer.MAX_VALUE] : new long[(this.actualSizeInWords + number) * 3 / 2]);
            System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
            this.rlw.parent.buffer = this.buffer;
        }
        for (int k = 0; k < number; ++k) {
            this.buffer[this.actualSizeInWords + k] = data[start + k] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.actualSizeInWords += number;
    }

    @Override
    public void not() {
        RunningLengthWord rlw1;
        EWAHIterator i = this.getEWAHIterator();
        if (!i.hasNext()) {
            return;
        }
        do {
            rlw1.setRunningBit(!(rlw1 = i.next()).getRunningBit());
            for (int j = 0; j < rlw1.getNumberOfLiteralWords(); ++j) {
                i.buffer()[i.literalWords() + j] = i.buffer()[i.literalWords() + j] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } while (i.hasNext());
        int usedBitsInLast = this.sizeInBits % 64;
        if (usedBitsInLast == 0) {
            return;
        }
        if (rlw1.getNumberOfLiteralWords() == 0) {
            if (rlw1.getRunningLength() > 0L && rlw1.getRunningBit()) {
                if (rlw1.getRunningLength() == 1L && rlw1.position > 0) {
                    EWAHIterator j = this.getEWAHIterator();
                    int newrlwpos = this.rlw.position;
                    while (j.hasNext()) {
                        RunningLengthWord r = j.next();
                        if (r.position >= rlw1.position) break;
                        newrlwpos = r.position;
                    }
                    this.rlw.position = newrlwpos;
                    --this.actualSizeInWords;
                } else {
                    rlw1.setRunningLength(rlw1.getRunningLength() - 1L);
                }
                this.addLiteralWord(-1L >>> 64 - usedBitsInLast);
            }
            return;
        }
        long[] lArray = i.buffer();
        int n = i.literalWords() + rlw1.getNumberOfLiteralWords() - 1;
        lArray[n] = lArray[n] & -1L >>> 64 - usedBitsInLast;
        if (i.buffer()[i.literalWords() + rlw1.getNumberOfLiteralWords() - 1] == 0L) {
            this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
            --this.actualSizeInWords;
            this.addEmptyWord(false);
        }
    }

    @Override
    public EWAHCompressedBitmap or(EWAHCompressedBitmap a) {
        int size = this.actualSizeInWords + a.actualSizeInWords;
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size);
        this.orToContainer(a, container);
        return container;
    }

    public void orToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        container.clear();
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(true, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else {
                    long index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) | rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int orCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.orToContainer(a, counter);
        return counter.getCount();
    }

    private void push_back(long data) {
        if (this.actualSizeInWords == this.buffer.length) {
            long[] oldBuffer = this.buffer;
            this.buffer = oldBuffer.length < 32768 ? new long[oldBuffer.length * 2] : (oldBuffer.length * 3 / 2 < oldBuffer.length ? new long[Integer.MAX_VALUE] : new long[oldBuffer.length * 3 / 2]);
            System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
            this.rlw.parent.buffer = this.buffer;
        }
        this.buffer[this.actualSizeInWords++] = data;
    }

    private void push_back(long[] data, int start, int number) {
        if (this.actualSizeInWords + number >= this.buffer.length) {
            long[] oldBuffer = this.buffer;
            this.buffer = this.actualSizeInWords + number < 32768 ? new long[(this.actualSizeInWords + number) * 2] : ((this.actualSizeInWords + number) * 3 / 2 < this.actualSizeInWords + number ? new long[Integer.MAX_VALUE] : new long[(this.actualSizeInWords + number) * 3 / 2]);
            System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
            this.rlw.parent.buffer = this.buffer;
        }
        System.arraycopy(data, start, this.buffer, this.actualSizeInWords, number);
        this.actualSizeInWords += number;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.sizeInBits);
        out.writeInt(this.actualSizeInWords);
        for (int k = 0; k < this.actualSizeInWords; ++k) {
            out.writeLong(this.buffer[k]);
        }
        out.writeInt(this.rlw.position);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public boolean get(int i) {
        if (i < 0 || i >= this.sizeInBits) {
            return false;
        }
        IteratingRLW j = this.getIteratingRLW();
        int wordi = i / 64;
        for (int wordChecked = 0; wordChecked <= wordi; wordChecked += j.getNumberOfLiteralWords()) {
            if (wordi < (wordChecked = (int)((long)wordChecked + j.getRunningLength()))) {
                return j.getRunningBit();
            }
            if (wordi < wordChecked + j.getNumberOfLiteralWords()) {
                long w = j.getLiteralWordAt(wordi - wordChecked);
                return (w & 1L << i) != 0L;
            }
            j.next();
        }
        return false;
    }

    public int getFirstSetBit() {
        int nword = 0;
        for (int pos = 0; pos < this.actualSizeInWords; ++pos) {
            boolean rb;
            long rl = this.buffer[pos] >>> 1 & 0xFFFFFFFFL;
            boolean bl = rb = (this.buffer[pos] & 1L) != 0L;
            if (rl > 0L && rb) {
                return nword * 64;
            }
            nword = (int)((long)nword + rl);
            long lw = this.buffer[pos] >>> 33;
            if (lw <= 0L) continue;
            long word = this.buffer[pos + 1];
            long T = word & -word;
            return nword * 64 + Long.bitCount(T - 1L);
        }
        return -1;
    }

    public boolean set(int i) {
        if (i > 0x7FFFFFBF || i < 0) {
            throw new IndexOutOfBoundsException("Set values should be between 0 and 2147483583");
        }
        if (i < this.sizeInBits) {
            return false;
        }
        int dist = (i + 64) / 64 - (this.sizeInBits + 64 - 1) / 64;
        this.sizeInBits = i + 1;
        if (dist > 0) {
            if (dist > 1) {
                this.fastaddStreamOfEmptyWords(false, dist - 1);
            }
            this.addLiteralWord(1L << i % 64);
            return true;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
            this.addLiteralWord(1L << i % 64);
            return true;
        }
        int n = this.actualSizeInWords - 1;
        this.buffer[n] = this.buffer[n] | 1L << i % 64;
        if (this.buffer[this.actualSizeInWords - 1] == -1L) {
            this.buffer[this.actualSizeInWords - 1] = 0L;
            --this.actualSizeInWords;
            this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
            this.addEmptyWord(true);
        }
        return true;
    }

    @Override
    public void setSizeInBitsWithinLastWord(int size) {
        if ((size + 64 - 1) / 64 != (this.sizeInBits + 64 - 1) / 64) {
            throw new RuntimeException("You can only reduce the size of the bitmap within the scope of the last word. To extend the bitmap, please call setSizeInBits(int,boolean).");
        }
        this.sizeInBits = size;
        int usedBitsInLast = this.sizeInBits % 64;
        if (usedBitsInLast == 0) {
            return;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            if (this.rlw.getRunningLength() > 0L && this.rlw.getRunningBit()) {
                if (this.rlw.getRunningLength() == 1L && this.rlw.position > 0) {
                    EWAHIterator j = this.getEWAHIterator();
                    int newrlwpos = this.rlw.position;
                    while (j.hasNext()) {
                        RunningLengthWord r = j.next();
                        if (r.position >= this.rlw.position) break;
                        newrlwpos = r.position;
                    }
                    this.rlw.position = newrlwpos;
                    --this.actualSizeInWords;
                } else {
                    this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
                }
                this.addLiteralWord(-1L >>> 64 - usedBitsInLast);
            }
            return;
        }
        int n = this.actualSizeInWords - 1;
        this.buffer[n] = this.buffer[n] & -1L >>> 64 - usedBitsInLast;
        if (this.buffer[this.actualSizeInWords - 1] == 0L) {
            this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
            --this.actualSizeInWords;
            this.addEmptyWord(false);
        }
    }

    public boolean setSizeInBits(int size, boolean defaultValue) {
        if (size <= this.sizeInBits) {
            return false;
        }
        if (!defaultValue) {
            EWAHCompressedBitmap.extendEmptyBits(this, this.sizeInBits, size);
        } else {
            int maskWidth;
            int maskShift;
            if (this.sizeInBits % 64 != 0) {
                if (this.rlw.getNumberOfLiteralWords() == 0) {
                    this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
                    this.addLiteralWord(0L);
                }
                maskShift = this.sizeInBits % 64;
                maskWidth = this.sizeInBits + 64 - this.sizeInBits % 64 < size ? 64 - this.sizeInBits % 64 : size - this.sizeInBits;
                int n = this.actualSizeInWords - 1;
                this.buffer[n] = this.buffer[n] | -1L >>> 64 - maskWidth << maskShift;
                if (this.buffer[this.actualSizeInWords - 1] == -1L) {
                    this.buffer[this.actualSizeInWords - 1] = 0L;
                    --this.actualSizeInWords;
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.addEmptyWord(true);
                }
                this.sizeInBits += maskWidth;
            }
            this.addStreamOfEmptyWords(defaultValue, size / 64 - this.sizeInBits / 64);
            if (this.sizeInBits < size) {
                if (this.rlw.getNumberOfLiteralWords() == 0) {
                    this.addLiteralWord(0L);
                }
                maskWidth = size - this.sizeInBits;
                maskShift = this.sizeInBits % 64;
                int n = this.actualSizeInWords - 1;
                this.buffer[n] = this.buffer[n] | -1L >>> 64 - maskWidth << maskShift;
            }
        }
        this.sizeInBits = size;
        return true;
    }

    @Override
    public int sizeInBits() {
        return this.sizeInBits;
    }

    @Override
    public int sizeInBytes() {
        return this.actualSizeInWords * 8;
    }

    public static EWAHCompressedBitmap threshold(int t, EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        EWAHCompressedBitmap.thresholdWithContainer(container, t, bitmaps);
        return container;
    }

    public static void thresholdWithContainer(BitmapStorage container, int t, EWAHCompressedBitmap ... bitmaps) {
        new RunningBitmapMerge().symmetric(new ThresholdFuncBitmap(t), container, bitmaps);
    }

    public int[] toArray() {
        int[] ans = new int[this.cardinality()];
        int inAnsPos = 0;
        int pos = 0;
        EWAHIterator i = this.getEWAHIterator();
        while (i.hasNext()) {
            int j;
            RunningLengthWord localRlw = i.next();
            if (localRlw.getRunningBit()) {
                j = 0;
                while ((long)j < localRlw.getRunningLength()) {
                    for (int c = 0; c < 64; ++c) {
                        ans[inAnsPos++] = pos++;
                    }
                    ++j;
                }
            } else {
                pos = (int)((long)pos + 64L * localRlw.getRunningLength());
            }
            for (j = 0; j < localRlw.getNumberOfLiteralWords(); ++j) {
                long T;
                for (long data = i.buffer()[i.literalWords() + j]; data != 0L; data ^= T) {
                    T = data & -data;
                    ans[inAnsPos++] = Long.bitCount(T - 1L) + pos;
                }
                pos += 64;
            }
        }
        return ans;
    }

    public String toDebugString() {
        StringBuilder ans = new StringBuilder();
        ans.append(" EWAHCompressedBitmap, size in bits = ");
        ans.append(this.sizeInBits).append(" size in words = ");
        ans.append(this.actualSizeInWords).append("\n");
        EWAHIterator i = this.getEWAHIterator();
        while (i.hasNext()) {
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                ans.append(localrlw.getRunningLength()).append(" 1x11\n");
            } else {
                ans.append(localrlw.getRunningLength()).append(" 0x00\n");
            }
            ans.append(localrlw.getNumberOfLiteralWords()).append(" dirties\n");
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                long data = i.buffer()[i.literalWords() + j];
                ans.append("\t").append(data).append("\n");
            }
        }
        return ans.toString();
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i = this.intIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void swap(EWAHCompressedBitmap other) {
        long[] tmp = this.buffer;
        this.buffer = other.buffer;
        other.buffer = tmp;
        int tmp2 = this.rlw.position;
        this.rlw.position = other.rlw.position;
        other.rlw.position = tmp2;
        int tmp3 = this.actualSizeInWords;
        this.actualSizeInWords = other.actualSizeInWords;
        other.actualSizeInWords = tmp3;
        int tmp4 = this.sizeInBits;
        this.sizeInBits = other.sizeInBits;
        other.sizeInBits = tmp4;
    }

    public void trim() {
        this.buffer = Arrays.copyOf(this.buffer, this.actualSizeInWords);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public EWAHCompressedBitmap xor(EWAHCompressedBitmap a) {
        int size = this.actualSizeInWords + a.actualSizeInWords;
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size);
        this.xorToContainer(a, container);
        return container;
    }

    public void xorToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        container.clear();
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord predator = i_is_prey ? rlwj : rlwi;
                long index = !predator.getRunningBit() ? prey.discharge(container, predator.getRunningLength()) : prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(predator.getRunningBit(), predator.getRunningLength() - index);
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) ^ rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int xorCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.xorToContainer(a, counter);
        return counter.getCount();
    }

    @Override
    public EWAHCompressedBitmap compose(EWAHCompressedBitmap a) {
        int size = this.actualSizeInWords;
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size);
        this.composeToContainer(a, container);
        return container;
    }

    public void composeToContainer(EWAHCompressedBitmap a, EWAHCompressedBitmap container) {
        container.clear();
        ChunkIterator iterator = this.chunkIterator();
        ChunkIterator aIterator = a.chunkIterator();
        int index = 0;
        while (iterator.hasNext() && aIterator.hasNext()) {
            int length;
            if (!iterator.nextBit()) {
                length = iterator.nextLength();
                container.setSizeInBits(index += length, false);
                iterator.move(length);
                continue;
            }
            length = Math.min(iterator.nextLength(), aIterator.nextLength());
            container.setSizeInBits(index += length, aIterator.nextBit());
            iterator.move(length);
            aIterator.move(length);
        }
        container.setSizeInBits(this.sizeInBits, false);
    }

    public static void andWithContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            throw new IllegalArgumentException("Need at least one bitmap");
        }
        if (bitmaps.length == 2) {
            bitmaps[0].andToContainer(bitmaps[1], container);
            return;
        }
        int initialSize = EWAHCompressedBitmap.calculateInitialSize(bitmaps);
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap(initialSize);
        EWAHCompressedBitmap tmp = new EWAHCompressedBitmap(initialSize);
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k = 2; k < bitmaps.length - 1; ++k) {
            answer.andToContainer(bitmaps[k], tmp);
            EWAHCompressedBitmap tmp2 = answer;
            answer = tmp;
            tmp = tmp2;
            tmp.clear();
        }
        answer.andToContainer(bitmaps[bitmaps.length - 1], container);
    }

    private static int calculateInitialSize(EWAHCompressedBitmap ... bitmaps) {
        int initialSize = 4;
        for (EWAHCompressedBitmap bitmap : bitmaps) {
            initialSize = Math.max(bitmap.actualSizeInWords, initialSize);
        }
        return initialSize;
    }

    public static EWAHCompressedBitmap and(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].and(bitmaps[1]);
        }
        int initialSize = EWAHCompressedBitmap.calculateInitialSize(bitmaps);
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap(initialSize);
        EWAHCompressedBitmap tmp = new EWAHCompressedBitmap(initialSize);
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k = 2; k < bitmaps.length; ++k) {
            answer.andToContainer(bitmaps[k], tmp);
            tmp.swap(answer);
            tmp.clear();
        }
        return answer;
    }

    public static int andCardinality(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter counter = new BitCounter();
        EWAHCompressedBitmap.andWithContainer(counter, bitmaps);
        return counter.getCount();
    }

    public static EWAHCompressedBitmap bitmapOf(int ... setBits) {
        EWAHCompressedBitmap a = new EWAHCompressedBitmap();
        for (int k : setBits) {
            a.set(k);
        }
        return a;
    }

    private static void extendEmptyBits(BitmapStorage storage, int currentSize, int newSize) {
        int currentLeftover = currentSize % 64;
        int finalLeftover = newSize % 64;
        storage.addStreamOfEmptyWords(false, newSize / 64 - currentSize / 64 + (finalLeftover != 0 ? 1 : 0) + (currentLeftover != 0 ? -1 : 0));
    }

    public static void orWithContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        long size = 0L;
        long sinBits = 0L;
        for (EWAHCompressedBitmap b : bitmaps) {
            size += (long)b.sizeInBytes();
            if (sinBits >= (long)b.sizeInBits()) continue;
            sinBits = b.sizeInBits();
        }
        if (size * 8L > sinBits) {
            FastAggregation.bufferedorWithContainer(container, 65536, bitmaps);
        } else {
            FastAggregation.orToContainer(container, bitmaps);
        }
    }

    public static void xorWithContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        long size = 0L;
        long sizeInBits = 0L;
        for (EWAHCompressedBitmap b : bitmaps) {
            size += (long)b.sizeInBytes();
            if (sizeInBits >= (long)b.sizeInBits()) continue;
            sizeInBits = b.sizeInBits();
        }
        if (size * 8L > sizeInBits) {
            FastAggregation.bufferedxorWithContainer(container, 65536, bitmaps);
        } else {
            FastAggregation.xorToContainer(container, bitmaps);
        }
    }

    public static EWAHCompressedBitmap or(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        int largestSize = EWAHCompressedBitmap.calculateInitialSize(bitmaps);
        EWAHCompressedBitmap container = new EWAHCompressedBitmap((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap.orWithContainer(container, bitmaps);
        return container;
    }

    public static EWAHCompressedBitmap xor(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        int largestSize = EWAHCompressedBitmap.calculateInitialSize(bitmaps);
        int size = (int)((double)largestSize * 1.5);
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size);
        EWAHCompressedBitmap.xorWithContainer(container, bitmaps);
        return container;
    }

    public static int orCardinality(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter counter = new BitCounter();
        EWAHCompressedBitmap.orWithContainer(counter, bitmaps);
        return counter.getCount();
    }
}

