/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import playn.core.AbstractAssetManager;
import playn.core.Image;
import playn.core.PlayN;
import playn.core.ResourceCallback;
import playn.core.Sound;
import playn.java.JavaAudio;
import playn.java.JavaImage;

public class JavaAssetManager
extends AbstractAssetManager {
    private String pathPrefix = "war";

    public void setPathPrefix(String prefix) {
        this.pathPrefix = prefix;
    }

    protected Image doGetImage(String path) {
        File imgFile = new File(this.pathPrefix, path);
        try {
            BufferedImage img = ImageIO.read(imgFile);
            return new JavaImage(img);
        }
        catch (Exception e) {
            PlayN.log().warn("Could not load image at " + imgFile, (Throwable)e);
            return new JavaImage(e);
        }
    }

    protected Sound doGetSound(String path) {
        path = path + ".wav";
        File file = new File(this.pathPrefix, path);
        return ((JavaAudio)PlayN.audio()).createSound(file);
    }

    protected void doGetText(String path, ResourceCallback<String> callback) {
        try {
            callback.done((Object)Files.toString((File)new File(this.pathPrefix, path), (Charset)Charsets.UTF_8));
        }
        catch (Throwable e) {
            callback.error(e);
        }
    }
}

