/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import playn.core.Asserts;
import playn.core.Canvas;
import playn.core.CanvasImage;
import playn.core.Image;
import playn.core.ResourceCallback;
import playn.java.JavaCanvas;

class JavaImage
implements CanvasImage {
    BufferedImage img;
    private JavaCanvas canvas;
    private Exception exception;

    JavaImage(BufferedImage img) {
        this.img = img;
    }

    public JavaImage(Exception assetLoadException) {
        this.exception = assetLoadException;
        this.img = this.createErrorImage(100, 100);
    }

    public Canvas canvas() {
        if (this.canvas == null) {
            this.canvas = new JavaCanvas(this.img.createGraphics(), this.width(), this.height());
        }
        return this.canvas;
    }

    public void replaceWith(Image img) {
        Asserts.checkArgument((boolean)(img instanceof JavaImage));
        this.img = ((JavaImage)img).img;
    }

    public void addCallback(ResourceCallback<Image> callback) {
        if (this.img == null) {
            callback.error((Throwable)(this.exception != null ? this.exception : new RuntimeException("Error loading image")));
        } else {
            callback.done((Object)this);
        }
    }

    public int width() {
        return this.img.getWidth();
    }

    public int height() {
        return this.img.getHeight();
    }

    public boolean isReady() {
        return this.img != null && this.exception == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createErrorImage(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = img.createGraphics();
        try {
            g.setColor(Color.red);
            for (int yy = 0; yy <= height / 15; ++yy) {
                for (int xx = 0; xx <= width / 45; ++xx) {
                    g.drawString("ERROR", xx * 45, yy * 15);
                }
            }
        }
        finally {
            g.dispose();
        }
        return img;
    }
}

