/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.Player;
import playn.core.Asserts;
import playn.core.PlayN;
import playn.core.Sound;

class JavaJLayerSound
implements Sound {
    private final File file;
    private Player player;
    private Thread thread;
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                JavaJLayerSound.this.player.play();
            }
            catch (JavaLayerException e) {
                PlayN.log().warn("Failed to play sound file: " + JavaJLayerSound.this.file.getName(), (Throwable)e);
            }
            catch (Throwable e) {
                PlayN.log().warn("Failed to play sound file: " + JavaJLayerSound.this.file.getName(), e);
            }
        }
    };

    public JavaJLayerSound(File file) {
        FileInputStream is;
        this.file = file;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            PlayN.log().warn("Failed to locate sound file: " + file.getName(), (Throwable)e);
            return;
        }
        try {
            this.player = new Player((InputStream)is);
        }
        catch (JavaLayerException e) {
            PlayN.log().warn("Failed to locate create player for sound file: " + file.getName(), (Throwable)e);
            return;
        }
        this.thread = new Thread(this.runnable);
    }

    public boolean play() {
        if (this.thread == null) {
            return false;
        }
        this.stop();
        if (this.thread.isAlive()) {
            PlayN.log().warn("Sound thread has not yet terminated. Will not play sound file: " + this.file.getName());
            return false;
        }
        try {
            this.thread.start();
            return true;
        }
        catch (IllegalThreadStateException ignore) {
            return false;
        }
    }

    public void stop() {
    }

    public void setLooping(boolean looping) {
        if (looping) {
            PlayN.log().info("Sorry, looping not currently supported in Java. Will play sound file once: " + this.file.getName());
        }
    }

    public void setVolume(float volume) {
        Asserts.checkArgument((0.0f <= volume && volume <= 1.0f ? 1 : 0) != 0, (Object)"Must ensure 0f <= volume <= 1f");
    }

    public boolean isPlaying() {
        return false;
    }
}

