/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import playn.core.Pattern;
import playn.java.JavaImage;

class JavaPattern
implements Pattern {
    TexturePaint paint;

    static Pattern create(JavaImage img) {
        return new JavaPattern(JavaPattern.createTexture(img.img, 1, 1));
    }

    private static TexturePaint createTexture(BufferedImage img, int width, int height) {
        return new TexturePaint(img, new Rectangle2D.Double(0.0, 0.0, width, height));
    }

    JavaPattern(TexturePaint paint) {
        this.paint = paint;
    }

    void updateSize() {
        BufferedImage img = this.paint.getImage();
        int imageWidth = img.getWidth();
        int imageHeight = img.getHeight();
        double anchorWidth = this.paint.getAnchorRect().getWidth();
        double anchorHeight = this.paint.getAnchorRect().getHeight();
        if ((double)imageWidth != anchorWidth || (double)imageHeight != anchorHeight) {
            this.paint = JavaPattern.createTexture(img, imageWidth, imageHeight);
        }
    }
}

