/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import playn.core.Asserts;
import playn.core.PlayN;
import playn.core.Sound;

class JavaSound
implements Sound {
    private Clip clip;
    private boolean looping;
    private boolean playing;
    private InputStream inputStream;
    private final File file;

    public JavaSound(File file) {
        this.file = file;
        try {
            this.clip = AudioSystem.getClip();
        }
        catch (LineUnavailableException e) {
            PlayN.log().warn("Unable to create clip for " + file);
            return;
        }
        catch (IllegalArgumentException e) {
            PlayN.log().info("Failed to load sound " + file + " due to " + e.toString());
            return;
        }
        this.clip.addLineListener(new LineListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update(LineEvent event) {
                LineEvent.Type type = event.getType();
                if (LineEvent.Type.STOP == type) {
                    try {
                        JavaSound.this.clip.close();
                    }
                    finally {
                        JavaSound.this.playing = false;
                    }
                }
            }
        });
    }

    public boolean play() {
        AudioInputStream ais;
        if (this.playing) {
            return false;
        }
        if (this.clip == null) {
            return false;
        }
        if (this.clip.isActive()) {
            return false;
        }
        try {
            this.inputStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            PlayN.log().warn("Sound file not found " + this.file);
            return false;
        }
        try {
            ais = AudioSystem.getAudioInputStream(this.inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            PlayN.log().warn("Failed to play sound " + this.file + " due to failure to get audio stream caused by " + e.toString(), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            PlayN.log().warn("Failed to play sound " + this.file + " due to failure to get audio stream caused by " + e.toString(), (Throwable)e);
            return false;
        }
        try {
            this.clip.open(ais);
        }
        catch (IOException e) {
            PlayN.log().warn("Failed to play sound " + this.file + " due to failure to open clip caused by " + e.toString(), (Throwable)e);
            return false;
        }
        catch (LineUnavailableException e) {
            PlayN.log().info("Not playing sound " + this.file + " due to failure to open clip caused by " + e.toString());
        }
        catch (IllegalArgumentException e) {
            PlayN.log().info("Not playing sound " + this.file + " due to failure to open clip caused by " + e.toString());
            return false;
        }
        catch (IllegalStateException e) {
            PlayN.log().info("Not playing sound " + this.file + " due to failure to open clip caused by " + e.toString());
            return false;
        }
        if (this.looping) {
            this.clip.loop(-1);
        }
        this.clip.start();
        this.playing = true;
        return true;
    }

    public void stop() {
        if (this.clip == null) {
            return;
        }
        if (!this.clip.isActive()) {
            return;
        }
        this.clip.stop();
        this.clip.flush();
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public void setVolume(float volume) {
        Asserts.checkArgument((0.0f <= volume && volume <= 1.0f ? 1 : 0) != 0, (Object)"Must ensure 0f <= volume <= 1f");
    }

    public boolean isPlaying() {
        return this.playing;
    }
}

