/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import playn.core.Asserts;
import playn.core.CanvasSurface;
import playn.core.Image;
import playn.core.PlayN;
import playn.core.Surface;
import playn.core.SurfaceLayer;
import playn.java.JavaCanvas;
import playn.java.JavaImage;
import playn.java.JavaLayer;

class JavaSurfaceLayer
extends JavaLayer
implements SurfaceLayer {
    private JavaImage img;
    private Surface surface;

    JavaSurfaceLayer(int width, int height) {
        this.img = (JavaImage)PlayN.graphics().createImage(width, height);
        this.surface = new CanvasSurface(this.img.canvas());
    }

    public void destroy() {
        super.destroy();
        this.surface = null;
        this.img = null;
    }

    public Surface surface() {
        return this.surface;
    }

    @Override
    void paint(JavaCanvas canvas) {
        if (!this.visible()) {
            return;
        }
        canvas.save();
        this.transform(canvas);
        canvas.setAlpha(canvas.alpha() * this.alpha);
        canvas.drawImage((Image)this.img, 0.0f, 0.0f);
        canvas.restore();
    }

    public float width() {
        Asserts.checkNotNull((Object)this.surface, (Object)"Surface must not be null");
        return this.surface.width();
    }

    public float height() {
        Asserts.checkNotNull((Object)this.surface, (Object)"Surface must not be null");
        return this.surface.height();
    }

    public float scaledWidth() {
        return this.transform().scaleX() * this.width();
    }

    public float scaledHeight() {
        return this.transform().scaleY() * this.height();
    }
}

