/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import playn.core.Image;
import playn.core.ResourceCallback;
import playn.java.JavaImage;

class JavaErrorImage
extends JavaImage {
    private Exception exception;

    public JavaErrorImage(Exception assetLoadException) {
        super(JavaErrorImage.createErrorImage(100, 100));
        this.exception = assetLoadException;
    }

    public void addCallback(ResourceCallback<Image> callback) {
        callback.error((Throwable)(this.exception != null ? this.exception : new RuntimeException("Error loading image")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage createErrorImage(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = img.createGraphics();
        try {
            g.setColor(Color.red);
            for (int yy = 0; yy <= height / 15; ++yy) {
                for (int xx = 0; xx <= width / 45; ++xx) {
                    g.drawString("ERROR", xx * 45, yy * 15);
                }
            }
        }
        finally {
            g.dispose();
        }
        return img;
    }

    @Override
    public boolean isReady() {
        return false;
    }
}

