/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import playn.core.Asserts;
import playn.core.Image;
import playn.core.ImageLayer;
import playn.core.PlayN;
import playn.java.JavaCanvas;
import playn.java.JavaCanvasImage;
import playn.java.JavaImage;
import playn.java.JavaLayer;

class JavaImageLayer
extends JavaLayer
implements ImageLayer {
    private float width;
    private float height;
    private boolean widthSet;
    private boolean heightSet;
    private float sx;
    private float sy;
    private float sw;
    private float sh;
    private boolean sourceRectSet;
    private boolean repeatX;
    private boolean repeatY;
    private JavaImage image;
    private JavaCanvasImage cachedImage;
    private boolean dirty = true;

    JavaImageLayer() {
    }

    JavaImageLayer(JavaImage image) {
        this.image = image;
    }

    public void clearHeight() {
        this.heightSet = false;
    }

    public void clearSourceRect() {
        this.sourceRectSet = false;
    }

    public void clearWidth() {
        this.widthSet = false;
    }

    public Image image() {
        return this.image;
    }

    public void setHeight(float height) {
        Asserts.checkArgument((height > 0.0f ? 1 : 0) != 0, (Object)"Height must be > 0");
        this.heightSet = true;
        if (this.height != height) {
            this.height = height;
            this.dirty = true;
        }
    }

    public void setImage(Image image) {
        Asserts.checkArgument((boolean)(image instanceof JavaImage));
        this.image = (JavaImage)image;
        this.dirty = true;
    }

    public void setRepeatX(boolean repeat) {
        Asserts.checkArgument((!repeat || !this.sourceRectSet ? 1 : 0) != 0, (Object)"Cannot repeat when source rect is used");
        if (this.repeatX != repeat) {
            this.repeatX = repeat;
            this.dirty = true;
        }
    }

    public void setRepeatY(boolean repeat) {
        Asserts.checkArgument((!repeat || !this.sourceRectSet ? 1 : 0) != 0, (Object)"Cannot repeat when source rect is used");
        if (this.repeatY != repeat) {
            this.repeatY = repeat;
            this.dirty = true;
        }
    }

    public void setSourceRect(float sx, float sy, float sw, float sh) {
        Asserts.checkState((!this.repeatX && !this.repeatY ? 1 : 0) != 0, (Object)"Cannot use source rect when repeating x or y");
        this.sourceRectSet = true;
        this.sx = sx;
        this.sy = sy;
        this.sw = sw;
        this.sh = sh;
    }

    public void setWidth(float width) {
        Asserts.checkArgument((width > 0.0f ? 1 : 0) != 0, (Object)"Width must be > 0");
        this.widthSet = true;
        if (this.width != width) {
            this.width = width;
            this.dirty = true;
        }
    }

    public void setSize(float width, float height) {
        Asserts.checkArgument((width > 0.0f && height > 0.0f ? 1 : 0) != 0, (String)"Width and height must be > 0 (got %dx%d)", (Object[])new Object[]{Float.valueOf(width), Float.valueOf(height)});
        this.widthSet = true;
        if (this.width != width) {
            this.width = width;
            this.dirty = true;
        }
        this.heightSet = true;
        if (this.height != height) {
            this.height = height;
            this.dirty = true;
        }
    }

    @Override
    void paint(JavaCanvas canvas) {
        float dh;
        if (!this.visible() || !this.image.isReady()) {
            return;
        }
        canvas.save();
        this.transform(canvas);
        canvas.setAlpha(canvas.alpha() * this.alpha);
        float dw = this.widthSet ? this.width : (float)this.image.width();
        float f = dh = this.heightSet ? this.height : (float)this.image.height();
        if (this.repeatX || this.repeatY) {
            if (this.dirty) {
                this.cachedImage = (JavaCanvasImage)PlayN.graphics().createImage((int)dw, (int)dh);
                float anchorWidth = this.repeatX ? (float)this.image.width() : dw;
                float anchorHeight = this.repeatY ? (float)this.image.height() : dh;
                TexturePaint tpaint = new TexturePaint(this.image.img, new Rectangle2D.Float(0.0f, 0.0f, anchorWidth, anchorHeight));
                ((JavaCanvas)this.cachedImage.canvas()).gfx.setPaint(tpaint);
                ((JavaCanvas)this.cachedImage.canvas()).gfx.fill(new Rectangle2D.Float(0.0f, 0.0f, dw, dh));
                this.dirty = false;
            }
            canvas.drawImage(this.cachedImage, 0.0f, 0.0f);
        } else if (this.sourceRectSet) {
            canvas.drawImage(this.image, 0.0f, 0.0f, dw, dh, this.sx, this.sy, this.sw, this.sh);
        } else {
            canvas.drawImage(this.image, 0.0f, 0.0f);
        }
        canvas.restore();
    }

    public float width() {
        Asserts.checkNotNull((Object)this.image, (Object)"Image must not be null");
        if (this.widthSet) {
            return this.width;
        }
        return this.image.width();
    }

    public float height() {
        Asserts.checkNotNull((Object)this.image, (Object)"Image must not be null");
        if (this.heightSet) {
            return this.height;
        }
        return this.image.height();
    }

    public float scaledWidth() {
        return this.transform().scaleX() * this.width();
    }

    public float scaledHeight() {
        return this.transform().scaleY() * this.height();
    }
}

