/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import playn.core.Key;
import playn.core.Keyboard;

class JavaKeyboard
implements Keyboard {
    private Keyboard.Listener listener;

    JavaKeyboard(JFrame frame) {
        frame.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent nativeEvent) {
                if (JavaKeyboard.this.listener != null) {
                    Keyboard.Event.Impl event = new Keyboard.Event.Impl((double)nativeEvent.getWhen(), JavaKeyboard.keyForCode(nativeEvent.getKeyCode()));
                    JavaKeyboard.this.listener.onKeyDown((Keyboard.Event)event);
                    if (event.getPreventDefault()) {
                        nativeEvent.consume();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent nativeEvent) {
                if (JavaKeyboard.this.listener != null) {
                    Keyboard.Event.Impl event = new Keyboard.Event.Impl((double)nativeEvent.getWhen(), JavaKeyboard.keyForCode(nativeEvent.getKeyCode()));
                    JavaKeyboard.this.listener.onKeyUp((Keyboard.Event)event);
                    if (event.getPreventDefault()) {
                        nativeEvent.consume();
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent nativeEvent) {
                if (JavaKeyboard.this.listener != null && !Character.isISOControl(nativeEvent.getKeyChar())) {
                    Keyboard.TypedEvent.Impl event = new Keyboard.TypedEvent.Impl((double)nativeEvent.getWhen(), nativeEvent.getKeyChar());
                    JavaKeyboard.this.listener.onKeyTyped((Keyboard.TypedEvent)event);
                    if (event.getPreventDefault()) {
                        nativeEvent.consume();
                    }
                }
            }
        });
    }

    public void setListener(Keyboard.Listener listener) {
        this.listener = listener;
    }

    private static Key keyForCode(int keyCode) {
        switch (keyCode) {
            case 10: {
                return Key.ENTER;
            }
            case 8: {
                return Key.BACKSPACE;
            }
            case 9: {
                return Key.TAB;
            }
            case 12: {
                return Key.CLEAR;
            }
            case 16: {
                return Key.SHIFT;
            }
            case 17: {
                return Key.CONTROL;
            }
            case 18: {
                return Key.ALT;
            }
            case 19: {
                return Key.PAUSE;
            }
            case 20: {
                return Key.CAPS_LOCK;
            }
            case 27: {
                return Key.ESCAPE;
            }
            case 32: {
                return Key.SPACE;
            }
            case 33: {
                return Key.PAGE_UP;
            }
            case 34: {
                return Key.PAGE_DOWN;
            }
            case 35: {
                return Key.END;
            }
            case 36: {
                return Key.HOME;
            }
            case 37: {
                return Key.LEFT;
            }
            case 38: {
                return Key.UP;
            }
            case 39: {
                return Key.RIGHT;
            }
            case 40: {
                return Key.DOWN;
            }
            case 44: {
                return Key.COMMA;
            }
            case 45: {
                return Key.MINUS;
            }
            case 46: {
                return Key.PERIOD;
            }
            case 47: {
                return Key.SLASH;
            }
            case 48: {
                return Key.K0;
            }
            case 49: {
                return Key.K1;
            }
            case 50: {
                return Key.K2;
            }
            case 51: {
                return Key.K3;
            }
            case 52: {
                return Key.K4;
            }
            case 53: {
                return Key.K5;
            }
            case 54: {
                return Key.K6;
            }
            case 55: {
                return Key.K7;
            }
            case 56: {
                return Key.K8;
            }
            case 57: {
                return Key.K9;
            }
            case 59: {
                return Key.SEMICOLON;
            }
            case 61: {
                return Key.EQUALS;
            }
            case 65: {
                return Key.A;
            }
            case 66: {
                return Key.B;
            }
            case 67: {
                return Key.C;
            }
            case 68: {
                return Key.D;
            }
            case 69: {
                return Key.E;
            }
            case 70: {
                return Key.F;
            }
            case 71: {
                return Key.G;
            }
            case 72: {
                return Key.H;
            }
            case 73: {
                return Key.I;
            }
            case 74: {
                return Key.J;
            }
            case 75: {
                return Key.K;
            }
            case 76: {
                return Key.L;
            }
            case 77: {
                return Key.M;
            }
            case 78: {
                return Key.N;
            }
            case 79: {
                return Key.O;
            }
            case 80: {
                return Key.P;
            }
            case 81: {
                return Key.Q;
            }
            case 82: {
                return Key.R;
            }
            case 83: {
                return Key.S;
            }
            case 84: {
                return Key.T;
            }
            case 85: {
                return Key.U;
            }
            case 86: {
                return Key.V;
            }
            case 87: {
                return Key.W;
            }
            case 88: {
                return Key.X;
            }
            case 89: {
                return Key.Y;
            }
            case 90: {
                return Key.Z;
            }
            case 91: {
                return Key.LEFT_BRACKET;
            }
            case 92: {
                return Key.BACKSLASH;
            }
            case 93: {
                return Key.RIGHT_BRACKET;
            }
            case 96: {
                return Key.NP0;
            }
            case 97: {
                return Key.NP1;
            }
            case 98: {
                return Key.NP2;
            }
            case 99: {
                return Key.NP3;
            }
            case 100: {
                return Key.NP4;
            }
            case 101: {
                return Key.NP5;
            }
            case 102: {
                return Key.NP6;
            }
            case 103: {
                return Key.NP7;
            }
            case 104: {
                return Key.NP8;
            }
            case 105: {
                return Key.NP9;
            }
            case 106: {
                return Key.NP_MULTIPLY;
            }
            case 107: {
                return Key.NP_ADD;
            }
            case 109: {
                return Key.NP_SUBTRACT;
            }
            case 110: {
                return Key.NP_DECIMAL;
            }
            case 111: {
                return Key.NP_DIVIDE;
            }
            case 127: {
                return Key.DELETE;
            }
            case 144: {
                return Key.NP_NUM_LOCK;
            }
            case 145: {
                return Key.SCROLL_LOCK;
            }
            case 112: {
                return Key.F1;
            }
            case 113: {
                return Key.F2;
            }
            case 114: {
                return Key.F3;
            }
            case 115: {
                return Key.F4;
            }
            case 116: {
                return Key.F5;
            }
            case 117: {
                return Key.F6;
            }
            case 118: {
                return Key.F7;
            }
            case 119: {
                return Key.F8;
            }
            case 120: {
                return Key.F9;
            }
            case 121: {
                return Key.F10;
            }
            case 122: {
                return Key.F11;
            }
            case 123: {
                return Key.F12;
            }
            case 154: {
                return Key.PRINT_SCREEN;
            }
            case 155: {
                return Key.INSERT;
            }
            case 157: {
                return Key.META;
            }
            case 192: {
                return Key.BACKQUOTE;
            }
            case 222: {
                return Key.QUOTE;
            }
            case 224: {
                return Key.NP_UP;
            }
            case 225: {
                return Key.NP_DOWN;
            }
            case 226: {
                return Key.NP_LEFT;
            }
            case 227: {
                return Key.NP_RIGHT;
            }
            case 150: {
                return Key.AMPERSAND;
            }
            case 151: {
                return Key.ASTERISK;
            }
            case 152: {
                return Key.DOUBLE_QUOTE;
            }
            case 153: {
                return Key.LESS;
            }
            case 160: {
                return Key.GREATER;
            }
            case 161: {
                return Key.LEFT_BRACE;
            }
            case 162: {
                return Key.RIGHT_BRACE;
            }
            case 512: {
                return Key.AT;
            }
            case 513: {
                return Key.COLON;
            }
            case 514: {
                return Key.CIRCUMFLEX;
            }
            case 515: {
                return Key.DOLLAR;
            }
            case 517: {
                return Key.BANG;
            }
            case 519: {
                return Key.LEFT_PAREN;
            }
            case 520: {
                return Key.HASH;
            }
            case 521: {
                return Key.PLUS;
            }
            case 522: {
                return Key.RIGHT_PAREN;
            }
            case 523: {
                return Key.UNDERSCORE;
            }
            case 524: {
                return Key.WINDOWS;
            }
            case 525: {
                return Key.MENU;
            }
            case 0: {
                return Key.UNKNOWN;
            }
        }
        return Key.UNKNOWN;
    }
}

