/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import playn.core.Mouse;

class JavaMouse
implements Mouse {
    private Mouse.Listener listener;

    JavaMouse(JComponent frame) {
        frame.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent nativeEvent) {
                if (JavaMouse.this.listener != null) {
                    Mouse.MotionEvent.Impl event = new Mouse.MotionEvent.Impl((double)nativeEvent.getWhen(), (float)nativeEvent.getX(), (float)nativeEvent.getY());
                    JavaMouse.this.listener.onMouseMove((Mouse.MotionEvent)event);
                    if (event.getPreventDefault()) {
                        nativeEvent.consume();
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent nativeEvent) {
                if (JavaMouse.this.listener != null) {
                    Mouse.MotionEvent.Impl event = new Mouse.MotionEvent.Impl((double)nativeEvent.getWhen(), (float)nativeEvent.getX(), (float)nativeEvent.getY());
                    JavaMouse.this.listener.onMouseMove((Mouse.MotionEvent)event);
                    if (event.getPreventDefault()) {
                        nativeEvent.consume();
                    }
                }
            }
        });
        frame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent nativeEvent) {
                if (JavaMouse.this.listener != null) {
                    Mouse.ButtonEvent.Impl event = new Mouse.ButtonEvent.Impl((double)nativeEvent.getWhen(), (float)nativeEvent.getX(), (float)nativeEvent.getY(), JavaMouse.getMouseButton(nativeEvent));
                    JavaMouse.this.listener.onMouseDown((Mouse.ButtonEvent)event);
                    if (event.getPreventDefault()) {
                        nativeEvent.consume();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent nativeEvent) {
                if (JavaMouse.this.listener != null) {
                    Mouse.ButtonEvent.Impl event = new Mouse.ButtonEvent.Impl((double)nativeEvent.getWhen(), (float)nativeEvent.getX(), (float)nativeEvent.getY(), JavaMouse.getMouseButton(nativeEvent));
                    JavaMouse.this.listener.onMouseUp((Mouse.ButtonEvent)event);
                    if (event.getPreventDefault()) {
                        nativeEvent.consume();
                    }
                }
            }
        });
        frame.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent nativeEvent) {
                if (JavaMouse.this.listener != null) {
                    Mouse.WheelEvent.Impl event = new Mouse.WheelEvent.Impl((double)nativeEvent.getWhen(), (float)nativeEvent.getWheelRotation());
                    JavaMouse.this.listener.onMouseWheelScroll((Mouse.WheelEvent)event);
                    if (event.getPreventDefault()) {
                        nativeEvent.consume();
                    }
                }
            }
        });
    }

    public void setListener(Mouse.Listener listener) {
        this.listener = listener;
    }

    protected static int getMouseButton(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return e.getButton();
    }
}

