/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import playn.core.Analytics;
import playn.core.Audio;
import playn.core.Game;
import playn.core.Json;
import playn.core.Keyboard;
import playn.core.Log;
import playn.core.Mouse;
import playn.core.Net;
import playn.core.Platform;
import playn.core.PlayN;
import playn.core.Pointer;
import playn.core.RegularExpression;
import playn.core.Storage;
import playn.core.Touch;
import playn.core.json.JsonImpl;
import playn.java.JavaAnalytics;
import playn.java.JavaAssets;
import playn.java.JavaAudio;
import playn.java.JavaCanvas;
import playn.java.JavaGraphics;
import playn.java.JavaKeyboard;
import playn.java.JavaLog;
import playn.java.JavaMouse;
import playn.java.JavaNet;
import playn.java.JavaPointer;
import playn.java.JavaRegularExpression;
import playn.java.JavaStorage;

public class JavaPlatform
implements Platform {
    private static final float MAX_DELTA = 100.0f;
    private static final float FRAME_TIME = 10.0f;
    private JComponent component;
    private JFrame frame;
    private Game game;
    private JavaRegularExpression regularExpression = new JavaRegularExpression();
    private JavaAudio audio = new JavaAudio();
    private JavaGraphics graphics;
    private Json json = new JsonImpl();
    private JavaKeyboard keyboard;
    private JavaLog log = new JavaLog();
    private JavaNet net = new JavaNet();
    private JavaPointer pointer;
    private JavaMouse mouse;
    private JavaStorage storage = new JavaStorage();
    private JavaAssets assets = new JavaAssets();
    private int updateRate = 0;
    private Analytics analytics = new JavaAnalytics();

    public static JavaPlatform register() {
        JavaPlatform platform = new JavaPlatform();
        PlayN.setPlatform((Platform)platform);
        platform.init();
        return platform;
    }

    private JavaPlatform() {
        this.ensureFrame();
        this.graphics = new JavaGraphics(this.frame, this.component);
        this.keyboard = new JavaKeyboard(this.frame);
        this.pointer = new JavaPointer(this.component);
        this.mouse = new JavaMouse(this.component);
    }

    private void init() {
        this.storage.init();
    }

    public Audio audio() {
        return this.audio;
    }

    public JavaGraphics graphics() {
        return this.graphics;
    }

    public Json json() {
        return this.json;
    }

    public Keyboard keyboard() {
        return this.keyboard;
    }

    public Log log() {
        return this.log;
    }

    public Net net() {
        return this.net;
    }

    public Pointer pointer() {
        return this.pointer;
    }

    public Mouse mouse() {
        return this.mouse;
    }

    public Touch touch() {
        throw new UnsupportedOperationException("Touch is not yet supported on the Java platform");
    }

    public Storage storage() {
        return this.storage;
    }

    public Analytics analytics() {
        return this.analytics;
    }

    public JavaAssets assets() {
        return this.assets;
    }

    @Deprecated
    public JavaAssets assetManager() {
        return this.assets;
    }

    public float random() {
        return (float)Math.random();
    }

    public void run(Game game) {
        this.updateRate = game.updateRate();
        this.game = game;
        game.init();
        this.frame.setVisible(true);
    }

    public double time() {
        return System.currentTimeMillis();
    }

    public Platform.Type type() {
        return Platform.Type.JAVA;
    }

    private void ensureFrame() {
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(3);
        this.component = new JComponent(){
            private float accum;
            private double lastUpdateTime;
            private double lastPaintTime;
            private boolean isPaintDirty;
            {
                this.accum = JavaPlatform.this.updateRate;
            }

            @Override
            public void paint(Graphics g) {
                this.isPaintDirty = false;
                if (JavaPlatform.this.game != null) {
                    double now = JavaPlatform.this.time();
                    float updateDelta = (float)(now - this.lastUpdateTime);
                    if (updateDelta > 1.0f) {
                        updateDelta = updateDelta > 100.0f ? 100.0f : updateDelta;
                        this.lastUpdateTime = now;
                        if (JavaPlatform.this.updateRate == 0) {
                            JavaPlatform.this.game.update(updateDelta);
                            this.accum = 0.0f;
                            this.isPaintDirty = true;
                        } else {
                            this.accum += updateDelta;
                            while (this.accum > (float)JavaPlatform.this.updateRate) {
                                JavaPlatform.this.game.update((float)JavaPlatform.this.updateRate);
                                this.accum -= (float)JavaPlatform.this.updateRate;
                                this.isPaintDirty = true;
                            }
                        }
                    }
                    float paintDelta = (float)(now - this.lastPaintTime);
                    if (this.isPaintDirty || paintDelta > 10.0f) {
                        if (JavaPlatform.this.updateRate == 0) {
                            JavaPlatform.this.game.paint(0.0f);
                        } else {
                            JavaPlatform.this.game.paint(this.accum / (float)JavaPlatform.this.updateRate);
                        }
                        int width = JavaPlatform.this.component.getWidth();
                        int height = JavaPlatform.this.component.getHeight();
                        JavaCanvas canvas = new JavaCanvas((Graphics2D)g, width, height);
                        canvas.clear();
                        JavaPlatform.this.graphics.rootLayer().paint(canvas);
                        this.lastPaintTime = now;
                    }
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.repaint();
            }
        };
        this.component.setOpaque(true);
        this.frame.add(this.component);
        this.frame.setResizable(false);
        this.component.setPreferredSize(new Dimension(640, 480));
        this.frame.pack();
    }

    public RegularExpression regularExpression() {
        return this.regularExpression;
    }

    public void openURL(String url) {
        System.out.println("Opening url: " + url);
        String browser = "chrome ";
        if (System.getProperty("os.name", "-").contains("indows")) {
            browser = "rundll32 url.dll,FileProtocolHandler ";
        }
        try {
            Runtime.getRuntime().exec(browser + url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setTitle(String title) {
        this.frame.setTitle(title);
    }
}

