/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import playn.core.Image;
import playn.core.ResourceCallback;
import playn.java.JavaImage;
import pythagoras.f.MathUtil;

public class JavaImageRegion
extends JavaImage
implements Image.Region {
    private final JavaImage parent;
    private final float sx;
    private final float sy;
    private final int swidth;
    private final int sheight;

    public float x() {
        return this.sx;
    }

    public float y() {
        return this.sy;
    }

    @Override
    public int width() {
        return this.swidth;
    }

    @Override
    public int height() {
        return this.sheight;
    }

    public Image parent() {
        return this.parent;
    }

    @Override
    public boolean isReady() {
        return this.parent.isReady();
    }

    public void addCallback(final ResourceCallback<? super Image> callback) {
        this.parent.addCallback((ResourceCallback)new ResourceCallback<Image>(){

            public void done(Image image) {
                callback.done((Object)JavaImageRegion.this);
            }

            public void error(Throwable err) {
                callback.error(err);
            }
        });
    }

    @Override
    public Image.Region subImage(float x, float y, float width, float height) {
        return this.parent.subImage(this.sx + x, this.sy + y, width, height);
    }

    JavaImageRegion(JavaImage parent, float sx, float sy, float swidth, float sheight) {
        super(null);
        this.parent = parent;
        this.sx = sx;
        this.sy = sy;
        this.swidth = MathUtil.iceil((float)swidth);
        this.sheight = MathUtil.iceil((float)sheight);
    }

    @Override
    TexturePaint createTexture(float width, float height) {
        return new TexturePaint(this.parent.img.getSubimage((int)this.sx, (int)this.sy, this.swidth, this.sheight), new Rectangle2D.Float(0.0f, 0.0f, width, height));
    }

    @Override
    void draw(Graphics2D gfx, float x, float y, float w, float h) {
        this.draw(gfx, x, y, w, h, 0.0f, 0.0f, this.swidth, this.sheight);
    }

    @Override
    void draw(Graphics2D gfx, float dx, float dy, float dw, float dh, float x, float y, float w, float h) {
        this.parent.draw(gfx, dx, dy, dw, dh, this.sx + x, this.sy + y, w, h);
    }
}

