/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import playn.core.Asserts;
import playn.core.Canvas;
import playn.core.CanvasImage;
import playn.core.CanvasLayer;
import playn.core.Image;
import playn.core.PlayN;
import playn.java.JavaCanvas;
import playn.java.JavaLayer;

class JavaCanvasLayer
extends JavaLayer
implements CanvasLayer {
    private CanvasImage canvas;

    JavaCanvasLayer(int width, int height) {
        this.canvas = PlayN.graphics().createImage((float)width, (float)height);
    }

    public Canvas canvas() {
        return this.canvas.canvas();
    }

    public void destroy() {
        super.destroy();
        this.canvas = null;
    }

    @Override
    void paint(JavaCanvas surf) {
        if (!this.visible()) {
            return;
        }
        surf.save();
        this.transform(surf);
        surf.setAlpha(surf.alpha() * this.alpha);
        surf.drawImage((Image)this.canvas, 0.0f, 0.0f);
        surf.restore();
    }

    public float width() {
        Asserts.checkNotNull((Object)this.canvas, (Object)"Canvas must not be null");
        return this.canvas.width();
    }

    public float height() {
        Asserts.checkNotNull((Object)this.canvas, (Object)"Canvas must not be null");
        return this.canvas.height();
    }

    public float scaledWidth() {
        return this.transform().scaleX() * this.width();
    }

    public float scaledHeight() {
        return this.transform().scaleY() * this.height();
    }
}

