/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import playn.core.PlayN;
import playn.core.gl.GLShader;
import playn.core.gl.IndexedTrisShader;
import playn.java.JavaGLContext;

public class JavaGLShader
extends IndexedTrisShader {
    private static final int SHADER_INFO_LOG_LEN = 4096;
    private static final int VERTEX_SIZE = 10;
    private static final int START_VERTS = 64;
    private static final int EXPAND_VERTS = 64;
    private static final int START_ELEMS = 96;
    private static final int EXPAND_ELEMS = 96;
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int SHORT_SIZE_BYTES = 2;
    private static final int VERTEX_STRIDE = 40;
    protected final JavaGLContext ctx;
    protected final int program;
    protected final int uScreenSizeLoc;
    protected final int aMatrix;
    protected final int aTranslation;
    protected final int aPosition;
    protected final int aTexture;
    protected FloatBuffer vertexData;
    protected ShortBuffer elementData;
    protected final int vertexBuffer;
    protected final int elementBuffer;
    protected int vertexOffset;
    protected int elementOffset;

    protected JavaGLShader(JavaGLContext ctx, String fragShader) {
        this.ctx = ctx;
        this.program = this.createProgram("uniform vec2 u_ScreenSize;\nattribute vec4 a_Matrix;\nattribute vec2 a_Translation;\nattribute vec2 a_Position;\nattribute vec2 a_Texture;\nvarying vec2 v_TexCoord;\nvoid main(void) {\n  mat3 transform = mat3(\n    a_Matrix[0], a_Matrix[1], 0,\n    a_Matrix[2], a_Matrix[3], 0,\n    a_Translation[0], a_Translation[1], 1);\n  gl_Position = vec4(transform * vec3(a_Position, 1.0), 1);\n  gl_Position.x /= (u_ScreenSize.x / 2.0);\n  gl_Position.y /= (u_ScreenSize.y / 2.0);\n  gl_Position.x -= 1.0;\n  gl_Position.y = 1.0 - gl_Position.y;\n  v_TexCoord = a_Texture;\n}", fragShader);
        this.uScreenSizeLoc = GL20.glGetUniformLocation((int)this.program, (CharSequence)"u_ScreenSize");
        this.aMatrix = GL20.glGetAttribLocation((int)this.program, (CharSequence)"a_Matrix");
        this.aTranslation = GL20.glGetAttribLocation((int)this.program, (CharSequence)"a_Translation");
        this.aPosition = GL20.glGetAttribLocation((int)this.program, (CharSequence)"a_Position");
        this.aTexture = GL20.glGetAttribLocation((int)this.program, (CharSequence)"a_Texture");
        this.vertexBuffer = GL15.glGenBuffers();
        this.elementBuffer = GL15.glGenBuffers();
        this.expandVerts(64);
        this.expandElems(96);
    }

    protected boolean prepare(int fbufWidth, int fbufHeight) {
        if (this.ctx.useShader((GLShader)this) && GL20.glIsProgram((int)this.program)) {
            GL20.glUseProgram((int)this.program);
            this.ctx.checkGLError("Shader.prepare useProgram");
            GL20.glUniform2f((int)this.uScreenSizeLoc, (float)fbufWidth, (float)fbufHeight);
            GL15.glBindBuffer((int)34962, (int)this.vertexBuffer);
            GL15.glBindBuffer((int)34963, (int)this.elementBuffer);
            this.ctx.checkGLError("Shader.prepare BindBuffer");
            GL20.glEnableVertexAttribArray((int)this.aMatrix);
            GL20.glEnableVertexAttribArray((int)this.aTranslation);
            GL20.glEnableVertexAttribArray((int)this.aPosition);
            if (this.aTexture != -1) {
                GL20.glEnableVertexAttribArray((int)this.aTexture);
            }
            this.ctx.checkGLError("Shader.prepare AttribArrays enabled");
            GL20.glVertexAttribPointer((int)this.aMatrix, (int)4, (int)5126, (boolean)false, (int)40, (long)0L);
            GL20.glVertexAttribPointer((int)this.aTranslation, (int)2, (int)5126, (boolean)false, (int)40, (long)16L);
            GL20.glVertexAttribPointer((int)this.aPosition, (int)2, (int)5126, (boolean)false, (int)40, (long)24L);
            if (this.aTexture != -1) {
                GL20.glVertexAttribPointer((int)this.aTexture, (int)2, (int)5126, (boolean)false, (int)40, (long)32L);
            }
            this.ctx.checkGLError("Shader.prepare AttribPointer");
            return true;
        }
        return false;
    }

    public void flush() {
        if (this.vertexOffset == 0) {
            return;
        }
        this.ctx.checkGLError("Shader.flush");
        this.vertexData.position(0);
        GL15.glBufferData((int)34962, (FloatBuffer)this.vertexData, (int)35040);
        GL15.glBufferData((int)34963, (ShortBuffer)this.elementData, (int)35040);
        this.ctx.checkGLError("Shader.flush BufferData");
        GL11.glDrawElements((int)4, (int)this.elementOffset, (int)5123, (long)0L);
        this.elementOffset = 0;
        this.vertexOffset = 0;
        this.ctx.checkGLError("Shader.flush DrawElements");
    }

    protected int beginPrimitive(int vertexCount, int elemCount) {
        int vertIdx = this.vertexOffset / 10;
        int verts = vertIdx + vertexCount;
        int elems = this.elementOffset + elemCount;
        int availVerts = this.vertexData.capacity() / 10;
        int availElems = this.elementData.capacity();
        if (verts > availVerts || elems > availElems) {
            this.flush();
            if (vertexCount > availVerts) {
                this.expandVerts(vertexCount);
            }
            if (elemCount > availElems) {
                this.expandElems(elemCount);
            }
            return 0;
        }
        return vertIdx;
    }

    protected void addVertex(float m00, float m01, float m10, float m11, float tx, float ty, float dx, float dy, float sx, float sy) {
        this.vertexData.position(this.vertexOffset);
        this.vertexData.put(m00);
        this.vertexData.put(m01);
        this.vertexData.put(m10);
        this.vertexData.put(m11);
        this.vertexData.put(tx);
        this.vertexData.put(ty);
        this.vertexData.put(dx);
        this.vertexData.put(dy);
        this.vertexData.put(sx);
        this.vertexData.put(sy);
        this.vertexOffset += 10;
    }

    protected void addElement(int index) {
        this.elementData.position(this.elementOffset);
        this.elementData.put((short)index);
        ++this.elementOffset;
        this.elementData.position(0);
    }

    protected int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = this.loadShader(35633, vertexSource);
        int fragmentShader = this.loadShader(35632, fragmentSource);
        int program = GL20.glCreateProgram();
        if (vertexShader == 0 || fragmentShader == 0 || program == 0) {
            return 0;
        }
        if (program != 0) {
            GL20.glAttachShader((int)program, (int)vertexShader);
            this.ctx.checkGLError("createProgram Attaching vertex shader");
            GL20.glAttachShader((int)program, (int)fragmentShader);
            this.ctx.checkGLError("createProgram Attaching fragment shader");
            GL20.glLinkProgram((int)program);
            int linkStatus = GL20.glGetProgram((int)program, (int)35714);
            if (linkStatus != 1) {
                PlayN.log().error("Could not link program: ");
                PlayN.log().error(GL20.glGetProgramInfoLog((int)program, (int)4096));
                GL20.glDeleteProgram((int)program);
                program = 0;
            }
        }
        return program;
    }

    private int loadShader(int type, String shaderSource) {
        int shader = GL20.glCreateShader((int)type);
        if (shader == 0) {
            return 0;
        }
        GL20.glShaderSource((int)shader, (CharSequence)shaderSource);
        GL20.glCompileShader((int)shader);
        int compiled = GL20.glGetShader((int)shader, (int)35713);
        if (compiled == 0) {
            PlayN.log().error("Could not compile shader " + type + ":");
            PlayN.log().error(GL20.glGetShaderInfoLog((int)shader, (int)4096));
            GL20.glDeleteShader((int)shader);
            shader = 0;
        }
        return shader;
    }

    private void expandVerts(int vertCount) {
        int newVerts;
        int n = newVerts = this.vertexData == null ? 0 : this.vertexData.capacity() / 10;
        while (newVerts < vertCount) {
            newVerts += 64;
        }
        this.vertexData = ByteBuffer.allocateDirect(newVerts * 40).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    private void expandElems(int elemCount) {
        int newElems;
        int n = newElems = this.elementData == null ? 0 : this.elementData.capacity();
        while (newElems < elemCount) {
            newElems += 96;
        }
        this.elementData = ByteBuffer.allocateDirect(newElems * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
    }

    static class Color
    extends JavaGLShader
    implements GLShader.Color {
        private int uColor;
        private int uAlpha;
        private int lastColor;
        private float lastAlpha;

        Color(JavaGLContext ctx) {
            super(ctx, "#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec4 u_Color;\nuniform float u_Alpha;\nvoid main(void) {\n  gl_FragColor = vec4(u_Color.rgb * u_Alpha, u_Color.a * u_Alpha);\n}");
            this.uColor = GL20.glGetUniformLocation((int)this.program, (CharSequence)"u_Color");
            this.uAlpha = GL20.glGetUniformLocation((int)this.program, (CharSequence)"u_Alpha");
        }

        public void prepare(int color, float alpha, int fbufWidth, int fbufHeight) {
            this.ctx.checkGLError("colorShader.prepare start");
            boolean wasntAlreadyActive = super.prepare(fbufWidth, fbufHeight);
            if (wasntAlreadyActive || color != this.lastColor || alpha != this.lastAlpha) {
                this.flush();
                GL20.glUniform1f((int)this.uAlpha, (float)alpha);
                this.lastAlpha = alpha;
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color >> 0 & 0xFF) / 255.0f;
                GL20.glUniform4f((int)this.uColor, (float)r, (float)g, (float)b, (float)a);
                this.lastColor = color;
                this.ctx.checkGLError("colorShader.prepare end");
            }
        }
    }

    static class Texture
    extends JavaGLShader
    implements GLShader.Texture {
        private int uTexture;
        private int uAlpha;
        private int lastTex;
        private float lastAlpha;

        Texture(JavaGLContext ctx) {
            super(ctx, "#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_Texture;\nvarying vec2 v_TexCoord;\nuniform float u_Alpha;\nvoid main(void) {\n  vec4 textureColor = texture2D(u_Texture, v_TexCoord);\n  gl_FragColor = vec4(textureColor.rgb * u_Alpha, textureColor.a * u_Alpha);\n}");
            this.uTexture = GL20.glGetUniformLocation((int)this.program, (CharSequence)"u_Texture");
            this.uAlpha = GL20.glGetUniformLocation((int)this.program, (CharSequence)"u_Alpha");
        }

        @Override
        public void flush() {
            GL11.glBindTexture((int)3553, (int)this.lastTex);
            super.flush();
        }

        public void prepare(Object texObj, float alpha, int fbufWidth, int fbufHeight) {
            this.ctx.checkGLError("textureShader.prepare start");
            boolean wasntAlreadyActive = super.prepare(fbufWidth, fbufHeight);
            if (wasntAlreadyActive) {
                GL13.glActiveTexture((int)33984);
                GL20.glUniform1i((int)this.uTexture, (int)0);
            }
            int tex = (Integer)texObj;
            if (wasntAlreadyActive || tex != this.lastTex || alpha != this.lastAlpha) {
                this.flush();
                GL20.glUniform1f((int)this.uAlpha, (float)alpha);
                this.lastAlpha = alpha;
                this.lastTex = tex;
                this.ctx.checkGLError("textureShader.prepare end");
            }
        }
    }
}

