/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import playn.core.Asserts;
import playn.core.Image;
import playn.core.ImageLayer;
import playn.core.PlayN;
import playn.java.JavaCanvas;
import playn.java.JavaCanvasImage;
import playn.java.JavaImage;
import playn.java.JavaLayer;
import playn.java.JavaPattern;

class JavaImageLayer
extends JavaLayer
implements ImageLayer {
    private float width;
    private float height;
    private boolean widthSet;
    private boolean heightSet;
    private boolean repeatX;
    private boolean repeatY;
    private JavaImage image;
    private JavaCanvasImage cachedImage;
    private boolean dirty = true;

    JavaImageLayer() {
    }

    JavaImageLayer(JavaImage image) {
        this.image = image;
    }

    public void clearHeight() {
        this.heightSet = false;
    }

    @Deprecated
    public void clearSourceRect() {
        if (this.image instanceof Image.Region) {
            this.setImage(((Image.Region)this.image).parent());
        }
    }

    public void clearWidth() {
        this.widthSet = false;
    }

    public Image image() {
        return this.image;
    }

    public void setHeight(float height) {
        Asserts.checkArgument((height > 0.0f ? 1 : 0) != 0, (Object)"Height must be > 0");
        this.heightSet = true;
        if (this.height != height) {
            this.height = height;
            this.dirty = true;
        }
    }

    public void setImage(Image image) {
        Asserts.checkArgument((boolean)(image instanceof JavaImage));
        this.image = (JavaImage)image;
        this.dirty = true;
    }

    public void setRepeatX(boolean repeat) {
        if (this.repeatX != repeat) {
            this.repeatX = repeat;
            this.dirty = true;
        }
    }

    public void setRepeatY(boolean repeat) {
        if (this.repeatY != repeat) {
            this.repeatY = repeat;
            this.dirty = true;
        }
    }

    @Deprecated
    public void setSourceRect(float sx, float sy, float sw, float sh) {
        JavaImage source = this.image instanceof Image.Region ? ((Image.Region)this.image).parent() : this.image;
        this.setImage((Image)source.subImage(sx, sy, sw, sh));
    }

    public void setWidth(float width) {
        Asserts.checkArgument((width > 0.0f ? 1 : 0) != 0, (Object)"Width must be > 0");
        this.widthSet = true;
        if (this.width != width) {
            this.width = width;
            this.dirty = true;
        }
    }

    public void setSize(float width, float height) {
        Asserts.checkArgument((width > 0.0f && height > 0.0f ? 1 : 0) != 0, (String)"Width and height must be > 0 (got %dx%d)", (Object[])new Object[]{Float.valueOf(width), Float.valueOf(height)});
        this.widthSet = true;
        if (this.width != width) {
            this.width = width;
            this.dirty = true;
        }
        this.heightSet = true;
        if (this.height != height) {
            this.height = height;
            this.dirty = true;
        }
    }

    @Override
    void paint(JavaCanvas canvas) {
        if (!this.visible() || !this.image.isReady()) {
            return;
        }
        canvas.save();
        this.transform(canvas);
        canvas.setAlpha(canvas.alpha() * this.alpha);
        float dw = this.width();
        float dh = this.height();
        if (this.repeatX || this.repeatY) {
            if (this.dirty) {
                this.cachedImage = (JavaCanvasImage)PlayN.graphics().createImage((float)((int)dw), (float)((int)dh));
                TexturePaint tpaint = ((JavaPattern)this.image.toPattern()).paint;
                ((JavaCanvas)this.cachedImage.canvas()).gfx.setPaint(tpaint);
                ((JavaCanvas)this.cachedImage.canvas()).gfx.fill(new Rectangle2D.Float(0.0f, 0.0f, dw, dh));
                this.dirty = false;
            }
            canvas.drawImage((Image)this.cachedImage, 0.0f, 0.0f);
        } else if (this.widthSet || this.heightSet) {
            canvas.drawImage((Image)this.image, 0.0f, 0.0f, dw, dh);
        } else {
            canvas.drawImage((Image)this.image, 0.0f, 0.0f);
        }
        canvas.restore();
    }

    public float width() {
        Asserts.checkNotNull((Object)this.image, (Object)"Image must not be null");
        return this.widthSet ? this.width : this.image.width();
    }

    public float height() {
        Asserts.checkNotNull((Object)this.image, (Object)"Image must not be null");
        return this.heightSet ? this.height : this.image.height();
    }

    public float scaledWidth() {
        return this.transform().scaleX() * this.width();
    }

    public float scaledHeight() {
        return this.transform().scaleY() * this.height();
    }
}

