/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Graphics2D;
import playn.core.Canvas;
import playn.core.CanvasSurface;
import playn.core.ImmediateLayer;
import playn.core.Surface;
import playn.java.JavaCanvas;
import playn.java.JavaCanvasState;
import playn.java.JavaLayer;

class JavaImmediateLayer
extends JavaLayer
implements ImmediateLayer {
    private final ImmediateLayer.Renderer renderer;

    public JavaImmediateLayer(ImmediateLayer.Renderer renderer) {
        this.renderer = renderer;
    }

    public ImmediateLayer.Renderer renderer() {
        return this.renderer;
    }

    @Override
    void paint(JavaCanvas canvas) {
        if (!this.visible()) {
            return;
        }
        canvas.save();
        this.transform(canvas);
        canvas.setAlpha(canvas.alpha() * this.alpha);
        this.render(canvas);
        canvas.restore();
    }

    protected void render(JavaCanvas canvas) {
        this.renderer.render((Surface)new CanvasSurface((Canvas)canvas));
    }

    static class Clipped
    extends JavaImmediateLayer
    implements ImmediateLayer.Clipped,
    JavaCanvasState.Clipper {
        private final int width;
        private final int height;

        public Clipped(int width, int height, ImmediateLayer.Renderer renderer) {
            super(renderer);
            this.width = width;
            this.height = height;
        }

        public float width() {
            return this.width;
        }

        public float height() {
            return this.height;
        }

        public float scaledWidth() {
            return this.transform().scaleX() * this.width();
        }

        public float scaledHeight() {
            return this.transform().scaleY() * this.height();
        }

        @Override
        public void setClip(Graphics2D gfx) {
            gfx.setClip(0, 0, this.width, this.height);
        }

        @Override
        protected void render(JavaCanvas canvas) {
            canvas.clip(this);
            super.render(canvas);
        }
    }
}

