/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.IOException;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import playn.core.Analytics;
import playn.core.Audio;
import playn.core.Game;
import playn.core.Json;
import playn.core.Keyboard;
import playn.core.Log;
import playn.core.Mouse;
import playn.core.Net;
import playn.core.Platform;
import playn.core.PlayN;
import playn.core.Pointer;
import playn.core.RegularExpression;
import playn.core.Storage;
import playn.core.Touch;
import playn.core.TouchStub;
import playn.core.json.JsonImpl;
import playn.core.util.RunQueue;
import playn.java.JavaAnalytics;
import playn.java.JavaAssets;
import playn.java.JavaAudio;
import playn.java.JavaGraphics;
import playn.java.JavaKeyboard;
import playn.java.JavaLog;
import playn.java.JavaMouse;
import playn.java.JavaNet;
import playn.java.JavaPointer;
import playn.java.JavaRegularExpression;
import playn.java.JavaStorage;

public class JavaPlatform
implements Platform {
    private static final float MAX_DELTA = 100.0f;
    private static final float FRAME_TIME = 10.0f;
    private static JavaPlatform instance;
    private final JavaAnalytics analytics = new JavaAnalytics();
    private final JavaAudio audio = new JavaAudio();
    private final JavaLog log = new JavaLog();
    private final JavaNet net = new JavaNet(this);
    private final JavaRegularExpression regex = new JavaRegularExpression();
    private final JavaStorage storage = new JavaStorage();
    private final JsonImpl json = new JsonImpl();
    private final JavaKeyboard keyboard = new JavaKeyboard();
    private final JavaPointer pointer = new JavaPointer();
    private final JavaGraphics graphics;
    private final JavaMouse mouse;
    private final JavaAssets assets;
    private final RunQueue runQueue = new RunQueue((Log)this.log);
    private int updateRate = 0;
    private float accum = this.updateRate;
    private double lastUpdateTime;
    private double lastPaintTime;

    public static JavaPlatform register() {
        String sfprop = System.getProperty("playn.scaleFactor");
        if (sfprop != null) {
            try {
                return JavaPlatform.register(Float.parseFloat(sfprop));
            }
            catch (Exception e) {
                System.err.println("Invalid scaleFactor supplied '" + sfprop + "': " + e);
            }
        }
        return JavaPlatform.register(1.0f);
    }

    public static JavaPlatform register(float scaleFactor) {
        if (instance != null) {
            return instance;
        }
        instance = new JavaPlatform(scaleFactor);
        PlayN.setPlatform((Platform)instance);
        instance.init();
        return instance;
    }

    public JavaPlatform(float scaleFactor) {
        this.graphics = new JavaGraphics(this, scaleFactor);
        this.mouse = new JavaMouse(this.graphics);
        this.assets = new JavaAssets(this.graphics, this.audio);
    }

    public void setTitle(String title) {
        Display.setTitle((String)title);
    }

    public Platform.Type type() {
        return Platform.Type.JAVA;
    }

    public Audio audio() {
        return this.audio;
    }

    public JavaGraphics graphics() {
        return this.graphics;
    }

    public Json json() {
        return this.json;
    }

    public Keyboard keyboard() {
        return this.keyboard;
    }

    public Log log() {
        return this.log;
    }

    public Net net() {
        return this.net;
    }

    public Pointer pointer() {
        return this.pointer;
    }

    public Mouse mouse() {
        return this.mouse;
    }

    public Touch touch() {
        return new TouchStub();
    }

    public Storage storage() {
        return this.storage;
    }

    public Analytics analytics() {
        return this.analytics;
    }

    public JavaAssets assets() {
        return this.assets;
    }

    public RegularExpression regularExpression() {
        return this.regex;
    }

    public float random() {
        return (float)Math.random();
    }

    public double time() {
        return System.currentTimeMillis();
    }

    public void openURL(String url) {
        System.out.println("Opening url: " + url);
        String browser = "chrome ";
        if (System.getProperty("os.name", "-").contains("indows")) {
            browser = "rundll32 url.dll,FileProtocolHandler ";
        }
        try {
            Runtime.getRuntime().exec(browser + url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void invokeLater(Runnable runnable) {
        this.runQueue.add(runnable);
    }

    public void run(Game game) {
        this.updateRate = game.updateRate();
        try {
            this.graphics.init();
            this.mouse.init();
            this.keyboard.init();
        }
        catch (LWJGLException e) {
            throw new RuntimeException("Unrecoverable initialization error", e);
        }
        game.init();
        while (!Display.isCloseRequested()) {
            float paintDelta;
            this.mouse.update();
            this.keyboard.update();
            this.pointer.update();
            this.net.update();
            this.runQueue.execute();
            double now = this.time();
            float updateDelta = (float)(now - this.lastUpdateTime);
            if (updateDelta > 1.0f) {
                updateDelta = updateDelta > 100.0f ? 100.0f : updateDelta;
                this.lastUpdateTime = now;
                if (this.updateRate == 0) {
                    game.update(updateDelta);
                    this.accum = 0.0f;
                } else {
                    this.accum += updateDelta;
                    while (this.accum > (float)this.updateRate) {
                        game.update((float)this.updateRate);
                        this.accum -= (float)this.updateRate;
                    }
                }
            }
            if ((paintDelta = (float)(now - this.lastPaintTime)) > 10.0f) {
                if (this.updateRate == 0) {
                    game.paint(0.0f);
                } else {
                    game.paint(this.accum / (float)this.updateRate);
                }
                this.graphics.paintLayers();
                this.lastPaintTime = now;
            }
            Display.sync((int)60);
            Display.update();
        }
        System.exit(0);
    }

    protected void init() {
        this.storage.init();
    }
}

