/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import playn.core.Asserts;
import playn.core.PlayN;
import playn.core.ResourceCallback;
import playn.core.Sound;
import playn.java.JavaAssets;

class JavaSound
implements Sound {
    private final String name;
    private Clip clip;
    private boolean looping;
    private List<ResourceCallback<? super Sound>> callbacks;

    JavaSound(String name, final InputStream inputStream) {
        this.name = name;
        JavaAssets.doResourceAction(new Runnable(){

            @Override
            public void run() {
                JavaSound.this.init(inputStream);
                if (JavaSound.this.callbacks != null) {
                    for (ResourceCallback callback : JavaSound.this.callbacks) {
                        callback.done((Object)JavaSound.this);
                    }
                    JavaSound.this.callbacks = null;
                }
            }
        });
    }

    private void init(InputStream inputStream) {
        AudioInputStream ais;
        try {
            this.clip = AudioSystem.getClip();
        }
        catch (LineUnavailableException e) {
            PlayN.log().warn("Unable to create clip for " + this.name);
            return;
        }
        catch (IllegalArgumentException e) {
            PlayN.log().info("Failed to load sound " + this.name + " due to " + e.toString());
            return;
        }
        try {
            ais = AudioSystem.getAudioInputStream(inputStream);
            if (this.name.endsWith(".mp3")) {
                AudioFormat baseFormat = ais.getFormat();
                AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                ais = AudioSystem.getAudioInputStream(decodedFormat, ais);
            }
        }
        catch (Exception e) {
            PlayN.log().warn("Failed to create audio stream for " + this.name, (Throwable)e);
            return;
        }
        try {
            this.clip.open(ais);
        }
        catch (Exception e) {
            PlayN.log().warn("Failed to open sound " + this.name, (Throwable)e);
            return;
        }
    }

    public boolean play() {
        if (this.clip == null) {
            return false;
        }
        if (this.looping) {
            this.clip.loop(-1);
        } else {
            this.clip.setFramePosition(0);
            this.clip.start();
        }
        return true;
    }

    public void stop() {
        if (this.clip == null) {
            return;
        }
        this.clip.stop();
        this.clip.flush();
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public void setVolume(float volume) {
        Asserts.checkArgument((0.0f <= volume && volume <= 1.0f ? 1 : 0) != 0, (Object)"Must ensure 0f <= volume <= 1f");
    }

    public boolean isPlaying() {
        return this.clip != null && this.clip.isActive();
    }

    public void addCallback(ResourceCallback<? super Sound> callback) {
        if (this.clip != null) {
            callback.done((Object)this);
        } else {
            if (this.callbacks == null) {
                this.callbacks = new ArrayList<ResourceCallback<? super Sound>>();
            }
            this.callbacks.add(callback);
        }
    }
}

