/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import playn.core.AbstractTextLayout;
import playn.core.Graphics;
import playn.core.TextFormat;
import playn.java.JavaCanvasState;
import playn.java.JavaFont;
import playn.java.JavaGraphics;

class JavaTextLayout
extends AbstractTextLayout {
    private static FontRenderContext dummyFontContext = JavaTextLayout.createDummyFRC();
    private List<TextLayout> layouts = new ArrayList<TextLayout>();
    private Color textColor;
    private Color altColor;
    private final JavaTextStamp stamp;
    private final JavaTextStamp altStamp;

    public JavaTextLayout(JavaGraphics gfx, String text, TextFormat format) {
        super((Graphics)gfx, format);
        text = text.replace("\r\n", "\n").replace('\r', '\n');
        AttributedString astring = new AttributedString(text);
        if (format.font != null) {
            astring.addAttribute(TextAttribute.FONT, ((JavaFont)format.font).jfont);
        }
        if (format.shouldWrap() || text.indexOf(10) != -1) {
            LineBreakMeasurer measurer = new LineBreakMeasurer(astring.getIterator(), dummyFontContext);
            int eol = 10;
            int lastPos = text.length();
            while (measurer.getPosition() < lastPos) {
                int nextRet = text.indexOf(eol, measurer.getPosition() + 1);
                if (nextRet == -1) {
                    nextRet = lastPos;
                }
                this.layouts.add(measurer.nextLayout(format.wrapWidth, nextRet, false));
            }
        } else {
            this.layouts.add(new TextLayout(astring.getIterator(), dummyFontContext));
        }
        float twidth = 0.0f;
        float theight = 0.0f;
        for (TextLayout layout : this.layouts) {
            Rectangle2D bounds = layout.getBounds();
            twidth = Math.max(twidth, JavaTextLayout.getWidth(bounds));
            if (layout != this.layouts.get(0)) {
                theight += layout.getLeading();
            }
            theight += layout.getAscent() + layout.getDescent();
        }
        this.width = twidth;
        this.height = theight;
        this.stamp = new JavaTextStamp(format.textColor);
        this.altStamp = format.effect.getAltColor() != null ? new JavaTextStamp(format.effect.getAltColor()) : null;
    }

    public int lineCount() {
        return this.layouts.size();
    }

    void stroke(Graphics2D gfx, float x, float y) {
        this.stamp.paint(gfx, x, y, true);
    }

    void draw(Graphics2D gfx, float x, float y) {
        Color ocolor = gfx.getColor();
        this.draw(gfx, this.stamp, this.altStamp, x, y);
        gfx.setColor(ocolor);
    }

    void fill(Graphics2D gfx, float x, float y) {
        this.stamp.paint(gfx, x, y, false);
    }

    private static float getWidth(Rectangle2D bounds) {
        return (float)(Math.max(-bounds.getX(), 0.0) + bounds.getWidth());
    }

    private static FontRenderContext createDummyFRC() {
        Graphics2D gfx = new BufferedImage(1, 1, 2).createGraphics();
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return gfx.getFontRenderContext();
    }

    private class JavaTextStamp
    implements AbstractTextLayout.Stamp<Graphics2D> {
        private final Color color;

        public JavaTextStamp(int color) {
            this.color = JavaCanvasState.convertColor(color);
        }

        public void draw(Graphics2D gfx, float x, float y) {
            gfx.setColor(this.color);
            this.paint(gfx, x, y, false);
        }

        public void paint(Graphics2D gfx, float x, float y, boolean stroke) {
            float yoff = y;
            for (TextLayout layout : JavaTextLayout.this.layouts) {
                Rectangle2D bounds = layout.getBounds();
                float sx = x + (float)(-bounds.getX()) + ((JavaTextLayout)JavaTextLayout.this).format.align.getX(JavaTextLayout.getWidth(bounds), JavaTextLayout.this.width);
                yoff += layout.getAscent();
                if (stroke) {
                    gfx.translate(sx, yoff);
                    gfx.draw(layout.getOutline(null));
                    gfx.translate(-sx, -yoff);
                } else {
                    layout.draw(gfx, sx, yoff);
                }
                yoff += layout.getDescent() + layout.getLeading();
            }
        }
    }
}

