/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.IOException;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import playn.core.AbstractPlatform;
import playn.core.Analytics;
import playn.core.Game;
import playn.core.Json;
import playn.core.Keyboard;
import playn.core.Log;
import playn.core.Mouse;
import playn.core.Net;
import playn.core.Platform;
import playn.core.PlayN;
import playn.core.Pointer;
import playn.core.RegularExpression;
import playn.core.Storage;
import playn.core.Touch;
import playn.core.TouchStub;
import playn.core.json.JsonImpl;
import playn.java.JavaAnalytics;
import playn.java.JavaAssets;
import playn.java.JavaAudio;
import playn.java.JavaGraphics;
import playn.java.JavaKeyboard;
import playn.java.JavaLog;
import playn.java.JavaMouse;
import playn.java.JavaNet;
import playn.java.JavaPointer;
import playn.java.JavaRegularExpression;
import playn.java.JavaStorage;

public class JavaPlatform
extends AbstractPlatform {
    private static final float MAX_DELTA = 100.0f;
    private static final float FRAME_TIME = 10.0f;
    private static JavaPlatform testInstance;
    private final JavaAnalytics analytics = new JavaAnalytics();
    private final JavaAudio audio = new JavaAudio();
    private final JavaNet net = new JavaNet(this);
    private final JavaRegularExpression regex = new JavaRegularExpression();
    private final JavaStorage storage = new JavaStorage();
    private final JsonImpl json = new JsonImpl();
    private final JavaKeyboard keyboard = new JavaKeyboard();
    private final JavaPointer pointer = new JavaPointer();
    private final JavaGraphics graphics;
    private final JavaMouse mouse = new JavaMouse(this);
    private final JavaAssets assets = new JavaAssets(this);
    private int updateRate = 0;
    private float accum = this.updateRate;
    private double lastUpdateTime;
    private double lastPaintTime;

    public static JavaPlatform register() {
        float scaleFactor = 1.0f;
        String sfprop = System.getProperty("playn.scaleFactor", String.valueOf(scaleFactor));
        try {
            return JavaPlatform.register(Float.parseFloat(sfprop));
        }
        catch (Exception e) {
            System.err.println("Invalid scaleFactor supplied '" + sfprop + "': " + e);
            return JavaPlatform.register(scaleFactor);
        }
    }

    public static JavaPlatform register(float scaleFactor) {
        JavaPlatform instance = new JavaPlatform(scaleFactor, false);
        PlayN.setPlatform((Platform)instance);
        return instance;
    }

    public static JavaPlatform registerHeadless() {
        if (testInstance != null) {
            return testInstance;
        }
        testInstance = new JavaPlatform(1.0f, true);
        PlayN.setPlatform((Platform)testInstance);
        return testInstance;
    }

    public JavaPlatform(float scaleFactor, boolean headless) {
        super((Log)new JavaLog());
        this.graphics = new JavaGraphics(this, scaleFactor, headless);
    }

    public void setTitle(String title) {
        Display.setTitle((String)title);
    }

    public Platform.Type type() {
        return Platform.Type.JAVA;
    }

    public JavaAudio audio() {
        return this.audio;
    }

    public JavaGraphics graphics() {
        return this.graphics;
    }

    public Json json() {
        return this.json;
    }

    public Keyboard keyboard() {
        return this.keyboard;
    }

    public Net net() {
        return this.net;
    }

    public Pointer pointer() {
        return this.pointer;
    }

    public Mouse mouse() {
        return this.mouse;
    }

    public Touch touch() {
        return new TouchStub();
    }

    public Storage storage() {
        return this.storage;
    }

    public Analytics analytics() {
        return this.analytics;
    }

    public JavaAssets assets() {
        return this.assets;
    }

    public RegularExpression regularExpression() {
        return this.regex;
    }

    public float random() {
        return (float)Math.random();
    }

    public double time() {
        return System.currentTimeMillis();
    }

    public void openURL(String url) {
        System.out.println("Opening url: " + url);
        String browser = "chrome ";
        if (System.getProperty("os.name", "-").contains("indows")) {
            browser = "rundll32 url.dll,FileProtocolHandler ";
        }
        try {
            Runtime.getRuntime().exec(browser + url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run(Game game) {
        this.updateRate = game.updateRate();
        this.storage.init();
        try {
            this.graphics.init();
            this.mouse.init();
            this.keyboard.init();
        }
        catch (LWJGLException e) {
            throw new RuntimeException("Unrecoverable initialization error", e);
        }
        game.init();
        boolean wasActive = Display.isActive();
        while (!Display.isCloseRequested()) {
            float paintDelta;
            this.mouse.update();
            this.keyboard.update();
            this.pointer.update();
            this.net.update();
            if (wasActive != Display.isActive()) {
                if (wasActive) {
                    this.onPause();
                } else {
                    this.onResume();
                }
                wasActive = Display.isActive();
            }
            this.runQueue.execute();
            double now = this.time();
            float updateDelta = (float)(now - this.lastUpdateTime);
            if (updateDelta > 1.0f) {
                updateDelta = updateDelta > 100.0f ? 100.0f : updateDelta;
                this.lastUpdateTime = now;
                if (this.updateRate == 0) {
                    game.update(updateDelta);
                    this.accum = 0.0f;
                } else {
                    this.accum += updateDelta;
                    while (this.accum > (float)this.updateRate) {
                        game.update((float)this.updateRate);
                        this.accum -= (float)this.updateRate;
                    }
                }
            }
            if ((paintDelta = (float)(now - this.lastPaintTime)) > 10.0f) {
                this.graphics.paint(game, this.updateRate == 0 ? 0.0f : this.accum / (float)this.updateRate);
                this.lastPaintTime = now;
            }
            Display.sync((int)60);
            Display.update();
        }
        this.onExit();
        System.exit(0);
    }
}

