/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import playn.core.PlayN;
import playn.core.ResourceCallback;
import playn.core.Sound;
import playn.java.JavaAssets;
import pythagoras.f.MathUtil;

class JavaSound
implements Sound {
    private Clip clip;
    private boolean looping;
    private List<ResourceCallback<? super Sound>> callbacks = NONE;
    protected static final List<ResourceCallback<? super Sound>> NONE = new ArrayList<ResourceCallback<? super Sound>>();

    JavaSound(final String name, final InputStream inputStream) {
        JavaAssets.doResourceAction(new Runnable(){

            @Override
            public void run() {
                try {
                    JavaSound.this.init(name, inputStream);
                    for (ResourceCallback callback : JavaSound.this.callbacks) {
                        callback.done((Object)JavaSound.this);
                    }
                }
                catch (Exception e) {
                    PlayN.log().warn("Sound initialization failed '" + name + "': " + e);
                    for (ResourceCallback callback : JavaSound.this.callbacks) {
                        callback.error((Throwable)e);
                    }
                }
                JavaSound.this.callbacks = NONE;
            }
        });
    }

    private void init(String name, InputStream inputStream) throws Exception {
        this.clip = AudioSystem.getClip();
        AudioInputStream ais = AudioSystem.getAudioInputStream(inputStream);
        if (name.endsWith(".mp3")) {
            AudioFormat baseFormat = ais.getFormat();
            AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
            ais = AudioSystem.getAudioInputStream(decodedFormat, ais);
        }
        this.clip.open(ais);
    }

    public boolean play() {
        if (this.clip == null) {
            return false;
        }
        this.clip.setFramePosition(0);
        if (this.looping) {
            this.clip.loop(-1);
        } else {
            this.clip.start();
        }
        return true;
    }

    public void stop() {
        if (this.clip == null) {
            return;
        }
        this.clip.stop();
        this.clip.flush();
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public float volume() {
        FloatControl volctrl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float min = volctrl.getMinimum();
        float range = 0.0f - min;
        float gain = volctrl.getValue();
        return (gain - min) / range;
    }

    public void setVolume(float volume) {
        FloatControl volctrl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float min = volctrl.getMinimum();
        float range = 0.0f - min;
        volctrl.setValue(min + range * MathUtil.clamp((float)volume, (float)0.0f, (float)1.0f));
    }

    public boolean isPlaying() {
        return this.clip != null && this.clip.isActive();
    }

    public void addCallback(ResourceCallback<? super Sound> callback) {
        if (this.clip != null) {
            callback.done((Object)this);
        } else {
            if (this.callbacks == NONE) {
                this.callbacks = new ArrayList<ResourceCallback<? super Sound>>();
            }
            this.callbacks.add(callback);
        }
    }
}

