/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import playn.core.PlayN;
import playn.core.Storage;

class JavaStorage
implements Storage {
    private static final File tempFile = new File(new File(System.getProperty("java.io.tmpdir")), "playn.tmp");
    private boolean isPersisted = false;
    private Properties properties;

    JavaStorage() {
    }

    public void init() {
        this.properties = this.maybeRetrieveProperties();
    }

    public void setItem(String key, String value) throws RuntimeException {
        this.properties.setProperty(key, value);
        this.maybePersistProperties(this.properties);
    }

    public void removeItem(String key) {
        this.properties.remove(key);
        this.maybePersistProperties(this.properties);
    }

    public String getItem(String key) {
        return this.properties.getProperty(key);
    }

    public Iterable<String> keys() {
        return this.properties.stringPropertyNames();
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    private void maybePersistProperties(Properties properties) {
        try {
            properties.store(new FileOutputStream(tempFile), null);
            this.isPersisted = true;
        }
        catch (Exception e) {
            PlayN.log().info("Error persisting properties: " + e.getMessage());
            this.isPersisted = false;
        }
    }

    private Properties maybeRetrieveProperties() {
        Properties properties = new Properties();
        if (tempFile.exists()) {
            try {
                properties.load(new FileInputStream(tempFile));
                this.isPersisted = true;
            }
            catch (Exception e) {
                PlayN.log().info("Error retrieving file: " + e.getMessage());
                this.isPersisted = false;
            }
        } else {
            this.maybePersistProperties(properties);
        }
        return properties;
    }
}

