/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import org.java_websocket.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import playn.core.Net;

public class JavaWebSocket
implements Net.WebSocket {
    private final WebSocketClient socket;
    private final Net.WebSocket.Listener listener;
    private final Queue<Event> pendingEvents = new LinkedList<Event>();

    JavaWebSocket(String uri, Net.WebSocket.Listener listener) {
        this.listener = listener;
        URI juri = null;
        try {
            juri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.socket = new WebSocketClient(juri){

            public void onMessage(ByteBuffer buffer) {
                JavaWebSocket.this.addEvent(new DataMessageEvent(buffer));
            }

            public void onMessage(String msg) {
                JavaWebSocket.this.addEvent(new TextMessageEvent(msg));
            }

            public void onError(Exception e) {
                JavaWebSocket.this.addEvent(new ErrorEvent(e.getMessage()));
            }

            public void onClose(int arg0, String arg1, boolean arg2) {
                JavaWebSocket.this.addEvent(new CloseEvent());
            }

            public void onOpen(ServerHandshake handshake) {
                JavaWebSocket.this.addEvent(new OpenEvent());
            }
        };
        this.socket.connect();
    }

    public void close() {
        this.socket.close();
    }

    public void send(String data) {
        try {
            this.socket.send(data);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void send(ByteBuffer data) {
        try {
            byte[] bytes = new byte[data.remaining()];
            data.get(bytes);
            this.socket.send(bytes);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    synchronized boolean update() {
        Event e;
        boolean ret = true;
        while (null != (e = this.pendingEvents.poll())) {
            ret = e.handle();
        }
        return ret;
    }

    private synchronized void addEvent(Event e) {
        this.pendingEvents.add(e);
    }

    private class ErrorEvent
    extends Event {
        final String reason;

        ErrorEvent(String reason) {
            this.reason = reason;
        }

        @Override
        boolean handle() {
            JavaWebSocket.this.listener.onError(this.reason);
            return true;
        }
    }

    private class TextMessageEvent
    extends Event {
        final String textMessage;

        TextMessageEvent(String message) {
            this.textMessage = message;
        }

        @Override
        boolean handle() {
            JavaWebSocket.this.listener.onTextMessage(this.textMessage);
            return true;
        }
    }

    private class DataMessageEvent
    extends Event {
        ByteBuffer dataMessage;

        DataMessageEvent(ByteBuffer buffer) {
            this.dataMessage = buffer;
        }

        @Override
        boolean handle() {
            JavaWebSocket.this.listener.onDataMessage(this.dataMessage);
            return true;
        }
    }

    private class CloseEvent
    extends Event {
        private CloseEvent() {
        }

        @Override
        boolean handle() {
            JavaWebSocket.this.listener.onClose();
            return false;
        }
    }

    private class OpenEvent
    extends Event {
        private OpenEvent() {
        }

        @Override
        boolean handle() {
            JavaWebSocket.this.listener.onOpen();
            return true;
        }
    }

    private abstract class Event {
        private Event() {
        }

        abstract boolean handle();
    }
}

