/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import playn.core.AbstractAssets;
import playn.core.AbstractPlatform;
import playn.core.AsyncImage;
import playn.core.Image;
import playn.core.Sound;
import playn.core.gl.Scale;
import playn.java.JavaAsyncImage;
import playn.java.JavaPlatform;
import pythagoras.f.MathUtil;

public class JavaAssets
extends AbstractAssets<BufferedImage> {
    private final JavaPlatform platform;
    private String pathPrefix = "";
    private Scale assetScale = null;

    public JavaAssets(JavaPlatform platform) {
        super((AbstractPlatform)platform);
        this.platform = platform;
    }

    public void setPathPrefix(String prefix) {
        if (prefix.startsWith("/") || prefix.endsWith("/")) {
            throw new IllegalArgumentException("Prefix must not start or end with '/'.");
        }
        this.pathPrefix = prefix.length() == 0 ? prefix : prefix + "/";
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setAssetScale(float scaleFactor) {
        this.assetScale = new Scale(scaleFactor);
    }

    public Image getRemoteImage(final String url, float width, float height) {
        final JavaAsyncImage image = this.platform.graphics().createAsyncImage(width, height);
        this.platform.invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    JavaAssets.this.setImageLater(image, ImageIO.read(new URL(url)), Scale.ONE);
                }
                catch (Exception error) {
                    JavaAssets.this.setErrorLater(image, error);
                }
            }
        });
        return image;
    }

    public Sound getSound(String path) {
        String soundPath = path + ".mp3";
        try {
            return this.platform.audio().createSound(soundPath, this.getAssetStream(soundPath));
        }
        catch (Exception e) {
            this.platform.log().warn("Sound load error " + soundPath + ": " + e);
            return new Sound.Error(e);
        }
    }

    public String getTextSync(String path) throws Exception {
        return Resources.toString((URL)this.requireResource(this.pathPrefix + path), (Charset)Charsets.UTF_8);
    }

    protected Image createStaticImage(BufferedImage bufimg, Scale scale) {
        return this.platform.graphics().createStaticImage(bufimg, scale);
    }

    protected AsyncImage<BufferedImage> createAsyncImage(float width, float height) {
        return this.platform.graphics().createAsyncImage(width, height);
    }

    protected Image loadImage(String path, AbstractAssets.ImageReceiver<BufferedImage> recv) {
        String fullPath = this.pathPrefix + path;
        Exception error = null;
        for (Scale.ScaledResource rsrc : this.assetScale().getScaledResources(fullPath)) {
            try {
                BufferedImage image = ImageIO.read(this.requireResource(rsrc.path));
                Scale viewScale = this.platform.graphics().ctx().scale;
                Scale imageScale = rsrc.scale;
                float viewImageRatio = viewScale.factor / imageScale.factor;
                if (viewImageRatio < 1.0f) {
                    image = this.scaleImage(image, viewImageRatio);
                    imageScale = viewScale;
                }
                return recv.imageLoaded((Object)image, imageScale);
            }
            catch (FileNotFoundException fnfe) {
                error = fnfe;
            }
            catch (Exception e) {
                error = e;
                break;
            }
        }
        this.platform.log().warn("Could not load image: " + fullPath + " [error=" + error + "]");
        return recv.loadFailed((Throwable)(error != null ? error : new FileNotFoundException(fullPath)));
    }

    InputStream getAssetStream(String path) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.pathPrefix + path);
        if (in == null) {
            throw new FileNotFoundException(path);
        }
        return in;
    }

    private URL requireResource(String path) throws FileNotFoundException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException(path);
        }
        return url;
    }

    private BufferedImage scaleImage(BufferedImage image, float viewImageRatio) {
        int swidth = MathUtil.iceil((float)(viewImageRatio * (float)image.getWidth()));
        int sheight = MathUtil.iceil((float)(viewImageRatio * (float)image.getHeight()));
        BufferedImage scaled = new BufferedImage(swidth, sheight, 2);
        Graphics2D gfx = scaled.createGraphics();
        gfx.drawImage(image.getScaledInstance(swidth, sheight, 4), 0, 0, null);
        gfx.dispose();
        return scaled;
    }

    private Scale assetScale() {
        return this.assetScale != null ? this.assetScale : this.platform.graphics().ctx().scale;
    }
}

