/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import playn.core.AudioImpl;
import playn.core.Platform;
import playn.java.JavaPlatform;
import playn.java.JavaSound;

class JavaAudio
extends AudioImpl {
    public JavaAudio(JavaPlatform platform) {
        super((Platform)platform);
    }

    JavaSound createSound(final String name, final InputStream in) {
        final JavaSound sound = new JavaSound();
        ((JavaPlatform)this.platform).invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    Clip clip = AudioSystem.getClip();
                    AudioInputStream ais = AudioSystem.getAudioInputStream(in);
                    if (name.endsWith(".mp3")) {
                        AudioFormat baseFormat = ais.getFormat();
                        AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                        ais = AudioSystem.getAudioInputStream(decodedFormat, ais);
                    }
                    clip.open(ais);
                    JavaAudio.this.dispatchLoaded(sound, clip);
                }
                catch (Exception e) {
                    JavaAudio.this.dispatchLoadError(sound, e);
                }
            }
        });
        return sound;
    }
}

