/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import playn.core.Asserts;
import playn.core.Image;
import playn.core.Pattern;
import playn.core.gl.GLContext;
import playn.core.gl.ImageGL;
import playn.core.gl.Scale;
import playn.java.JavaBitmapTransformer;
import playn.java.JavaCanvas;
import playn.java.JavaGLContext;
import playn.java.JavaImageRegion;
import playn.java.JavaPattern;
import playn.java.JavaStaticImage;
import pythagoras.f.MathUtil;

abstract class JavaImage
extends ImageGL
implements JavaCanvas.Drawable {
    protected BufferedImage img;

    JavaImage(GLContext ctx, BufferedImage img, Scale scale) {
        super(ctx, scale);
        this.img = img;
    }

    public float width() {
        return this.scale.invScaled((float)this.img.getWidth());
    }

    public float height() {
        return this.scale.invScaled((float)this.img.getHeight());
    }

    public boolean isReady() {
        return this.img != null;
    }

    public Image.Region subImage(float sx, float sy, float swidth, float sheight) {
        return new JavaImageRegion(this, sx, sy, swidth, sheight);
    }

    public Pattern toPattern() {
        Asserts.checkState((boolean)this.isReady(), (Object)"Cannot generate a pattern from unready image.");
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, this.width(), this.height());
        return new JavaPattern(this, new TexturePaint(this.img, rect));
    }

    public void getRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        this.img.getRGB(startX, startY, width, height, rgbArray, offset, scanSize);
    }

    public Image transform(Image.BitmapTransformer xform) {
        return new JavaStaticImage(this.ctx, ((JavaBitmapTransformer)xform).transform(this.img), this.scale);
    }

    @Override
    public void draw(Graphics2D gfx, float x, float y, float w, float h) {
        AffineTransform tx = new AffineTransform(w / (float)this.img.getWidth(), 0.0f, 0.0f, h / (float)this.img.getHeight(), x, y);
        gfx.drawImage(this.img, tx, null);
    }

    @Override
    public void draw(Graphics2D gfx, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        float scaleX = dw / (sw *= this.scale.factor);
        float scaleY = dh / (sh *= this.scale.factor);
        Shape oclip = gfx.getClip();
        gfx.clipRect(MathUtil.ifloor((float)dx), MathUtil.ifloor((float)dy), MathUtil.iceil((float)dw), MathUtil.iceil((float)dh));
        gfx.drawImage(this.img, new AffineTransform(scaleX, 0.0f, 0.0f, scaleY, dx - (sx *= this.scale.factor) * scaleX, dy - (sy *= this.scale.factor) * scaleY), null);
        gfx.setClip(oclip);
    }

    protected void updateTexture(int tex) {
        Asserts.checkState((this.img != null ? 1 : 0) != 0);
        ((JavaGLContext)this.ctx).updateTexture(tex, this.img);
    }
}

