/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import playn.core.AbstractPlatform;
import playn.core.Net;
import playn.core.NetImpl;
import playn.core.util.Callback;
import playn.java.JavaPlatform;
import playn.java.JavaWebSocket;

public class JavaNet
extends NetImpl {
    private static final int BUF_SIZE = 4096;
    private static final String ENCODING = "UTF-8";
    private List<JavaWebSocket> sockets = new ArrayList<JavaWebSocket>();

    public JavaNet(JavaPlatform platform) {
        super((AbstractPlatform)platform);
    }

    public Net.WebSocket createWebSocket(String url, Net.WebSocket.Listener listener) {
        JavaWebSocket socket = new JavaWebSocket(url, listener);
        this.sockets.add(socket);
        return socket;
    }

    public void get(final String urlStr, final Callback<String> callback) {
        this.platform.invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    URL url = new URL(JavaNet.this.canonicalizeUrl(urlStr));
                    URLConnection conn = url.openConnection();
                    if (conn instanceof HttpURLConnection) {
                        JavaNet.this.processResponse((HttpURLConnection)conn, (Callback<String>)callback);
                    } else {
                        JavaNet.this.platform.notifySuccess(callback, (Object)JavaNet.this.readContent(conn));
                    }
                }
                catch (MalformedURLException e) {
                    JavaNet.this.platform.notifyFailure(callback, (Throwable)e);
                }
                catch (IOException e) {
                    JavaNet.this.platform.notifyFailure(callback, (Throwable)e);
                }
            }

            public String toString() {
                return "JavaNet.get(" + urlStr + ")";
            }
        });
    }

    public void post(final String urlStr, final String data, final Callback<String> callback) {
        this.platform.invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    URL url = new URL(JavaNet.this.canonicalizeUrl(urlStr));
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("POST");
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setAllowUserInteraction(false);
                    conn.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
                    conn.connect();
                    conn.getOutputStream().write(data.getBytes(JavaNet.ENCODING));
                    conn.getOutputStream().close();
                    JavaNet.this.processResponse(conn, (Callback<String>)callback);
                }
                catch (MalformedURLException e) {
                    JavaNet.this.platform.notifyFailure(callback, (Throwable)e);
                }
                catch (IOException e) {
                    JavaNet.this.platform.notifyFailure(callback, (Throwable)e);
                }
            }

            public String toString() {
                return "JavaNet.post(" + urlStr + ")";
            }
        });
    }

    void update() {
        Iterator<JavaWebSocket> it = this.sockets.iterator();
        while (it.hasNext()) {
            JavaWebSocket s = it.next();
            if (s.update()) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(HttpURLConnection conn, Callback<String> callback) throws IOException {
        try {
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new Net.HttpException(code, conn.getResponseMessage());
            }
            this.platform.notifySuccess(callback, (Object)this.readContent(conn));
        }
        finally {
            conn.disconnect();
        }
    }

    private String canonicalizeUrl(String url) {
        if (!url.startsWith("http")) {
            return "http://" + this.server() + url;
        }
        return url;
    }

    private String server() {
        return "127.0.0.1:8080";
    }

    private String readContent(URLConnection conn) throws IOException {
        String encoding = conn.getContentEncoding() == null ? ENCODING : conn.getContentEncoding();
        InputStreamReader reader = new InputStreamReader(conn.getInputStream(), encoding);
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        int len = 0;
        while (-1 != (len = reader.read(buf))) {
            result.append(buf, 0, len);
        }
        return result.toString();
    }
}

