/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

class BigClip
implements Clip,
LineListener {
    private SourceDataLine dataLine;
    private byte[] audioData;
    private ByteArrayInputStream inputStream;
    private int loopCount = 1;
    private int countDown = 1;
    private int loopPointStart;
    private int loopPointEnd;
    private int framePosition;
    private Thread thread;
    private boolean active;
    private long timelastPositionSet;
    private int bufferUpdateFactor = 2;
    AudioFormat format;

    public BigClip() {
    }

    public BigClip(Clip clip) throws LineUnavailableException {
        this.dataLine = AudioSystem.getSourceDataLine(clip.getFormat());
    }

    public byte[] getAudioData() {
        return this.audioData;
    }

    private long convertFramesToMilliseconds(int frames) {
        return (long)frames / (long)this.dataLine.getFormat().getSampleRate() * 1000L;
    }

    private int convertMillisecondsToFrames(long milliseconds) {
        return (int)((float)milliseconds / this.dataLine.getFormat().getSampleRate());
    }

    @Override
    public void update(LineEvent le) {
    }

    @Override
    public void loop(int count) {
        this.loopCount = count;
        this.countDown = count;
        this.active = true;
        this.inputStream.reset();
        this.start();
    }

    @Override
    public void setLoopPoints(int start, int end) {
        if (start < 0 || start > this.audioData.length - 1 || end < 0 || end > this.audioData.length) {
            throw new IllegalArgumentException("Loop points '" + start + "' and '" + end + "' cannot be set for buffer of size " + this.audioData.length);
        }
        if (start > end) {
            throw new IllegalArgumentException("End position " + end + " preceeds start position " + start);
        }
        this.framePosition = this.loopPointStart = start;
        this.loopPointEnd = end;
    }

    @Override
    public void setMicrosecondPosition(long milliseconds) {
        this.framePosition = this.convertMillisecondsToFrames(milliseconds);
    }

    @Override
    public long getMicrosecondPosition() {
        return this.convertFramesToMilliseconds(this.getFramePosition());
    }

    @Override
    public long getMicrosecondLength() {
        return this.convertFramesToMilliseconds(this.getFrameLength());
    }

    @Override
    public void setFramePosition(int frames) {
        this.framePosition = frames;
        int offset = this.framePosition * this.format.getFrameSize();
        try {
            this.inputStream.reset();
            this.inputStream.read(new byte[offset]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getFramePosition() {
        long timeSinceLastPositionSet = System.currentTimeMillis() - this.timelastPositionSet;
        int size = this.dataLine.getBufferSize() * (this.format.getChannels() / 2) / this.bufferUpdateFactor;
        size /= this.dataLine.getFormat().getFrameSize();
        int framesSinceLast = (int)((float)timeSinceLastPositionSet / 1000.0f * this.dataLine.getFormat().getFrameRate());
        int framesRemainingTillTime = (size *= this.dataLine.getFormat().getFrameSize()) - framesSinceLast;
        return this.framePosition - framesRemainingTillTime;
    }

    @Override
    public int getFrameLength() {
        return this.audioData.length / this.format.getFrameSize();
    }

    @Override
    public void open(AudioInputStream stream) throws IOException, LineUnavailableException {
        AudioFormat afTemp;
        this.format = stream.getFormat();
        AudioInputStream is1 = this.format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED ? AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, stream) : stream;
        this.format = is1.getFormat();
        AudioInputStream is2 = is1;
        byte[] buf = new byte[65536];
        int totalRead = 0;
        int numRead = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        numRead = ((InputStream)is2).read(buf);
        while (numRead > -1) {
            baos.write(buf, 0, numRead);
            numRead = ((InputStream)is2).read(buf, 0, buf.length);
            totalRead += numRead;
        }
        ((InputStream)is2).close();
        this.audioData = baos.toByteArray();
        if (this.format.getChannels() < 2) {
            int frameSize = this.format.getSampleSizeInBits() * 2 / 8;
            afTemp = new AudioFormat(this.format.getEncoding(), this.format.getSampleRate(), this.format.getSampleSizeInBits(), 2, frameSize, this.format.getFrameRate(), this.format.isBigEndian());
        } else {
            afTemp = this.format;
        }
        this.setLoopPoints(0, this.audioData.length);
        this.dataLine = AudioSystem.getSourceDataLine(afTemp);
        this.dataLine.open();
        this.inputStream = new ByteArrayInputStream(this.audioData);
    }

    @Override
    public void open(AudioFormat format, byte[] data, int offset, int bufferSize) throws LineUnavailableException {
        byte[] input = new byte[bufferSize];
        for (int ii = 0; ii < input.length; ++ii) {
            input[ii] = data[offset + ii];
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        try {
            AudioInputStream ais1 = AudioSystem.getAudioInputStream(inputStream);
            AudioInputStream ais2 = AudioSystem.getAudioInputStream(format, ais1);
            this.open(ais2);
        }
        catch (UnsupportedAudioFileException uafe) {
            throw new IllegalArgumentException(uafe);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    @Override
    public float getLevel() {
        return this.dataLine.getLevel();
    }

    @Override
    public long getLongFramePosition() {
        return this.dataLine.getLongFramePosition() * 2L / (long)this.format.getChannels();
    }

    @Override
    public int available() {
        return this.dataLine.available();
    }

    @Override
    public int getBufferSize() {
        return this.dataLine.getBufferSize();
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public boolean isActive() {
        return this.dataLine.isActive();
    }

    @Override
    public boolean isRunning() {
        return this.dataLine.isRunning();
    }

    @Override
    public boolean isOpen() {
        return this.dataLine.isOpen();
    }

    @Override
    public void stop() {
        this.active = false;
        this.dataLine.stop();
        if (this.thread != null) {
            try {
                this.active = false;
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public byte[] convertMonoToStereo(byte[] data, int bytesRead) {
        byte[] tempData = new byte[bytesRead * 2];
        if (this.format.getSampleSizeInBits() == 8) {
            for (int ii = 0; ii < bytesRead; ++ii) {
                byte b;
                tempData[ii * 2] = b = data[ii];
                tempData[ii * 2 + 1] = b;
            }
        } else {
            for (int ii = 0; ii < bytesRead - 1; ii += 2) {
                byte b1 = data[ii];
                byte b2 = data[ii + 1];
                tempData[ii * 2] = b1;
                tempData[ii * 2 + 1] = b2;
                tempData[ii * 2 + 2] = b1;
                tempData[ii * 2 + 3] = b2;
            }
        }
        return tempData;
    }

    @Override
    public void start() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int offset;
                BigClip.this.dataLine.start();
                BigClip.this.active = true;
                int bytesRead = 0;
                int frameSize = BigClip.this.dataLine.getFormat().getFrameSize();
                int bufSize = BigClip.this.dataLine.getBufferSize();
                boolean startOrMove = true;
                byte[] data = new byte[bufSize];
                int totalBytes = offset = BigClip.this.framePosition * frameSize;
                bytesRead = BigClip.this.inputStream.read(new byte[offset], 0, offset);
                bytesRead = BigClip.this.inputStream.read(data, 0, data.length);
                while (bytesRead != -1 && (BigClip.this.loopCount == -1 || BigClip.this.countDown > 0) && BigClip.this.active) {
                    int framesRead;
                    byte[] tempData;
                    totalBytes += bytesRead;
                    if (BigClip.this.format.getChannels() < 2) {
                        tempData = BigClip.this.convertMonoToStereo(data, bytesRead);
                        framesRead = bytesRead / BigClip.this.format.getFrameSize();
                        bytesRead *= 2;
                    } else {
                        framesRead = bytesRead / BigClip.this.dataLine.getFormat().getFrameSize();
                        tempData = Arrays.copyOfRange(data, 0, bytesRead);
                    }
                    BigClip.this.framePosition += framesRead;
                    if (BigClip.this.framePosition >= BigClip.this.loopPointEnd) {
                        BigClip.this.framePosition = BigClip.this.loopPointStart;
                        BigClip.this.inputStream.reset();
                        BigClip.this.countDown--;
                    }
                    BigClip.this.timelastPositionSet = System.currentTimeMillis();
                    byte[] newData = tempData;
                    BigClip.this.dataLine.write(newData, 0, newData.length);
                    if (startOrMove) {
                        int len = bufSize / BigClip.this.bufferUpdateFactor;
                        len /= frameSize;
                        data = new byte[len *= frameSize];
                        startOrMove = false;
                    }
                    if ((bytesRead = BigClip.this.inputStream.read(data, 0, data.length)) >= 0 || --BigClip.this.countDown <= 0 && BigClip.this.loopCount != -1) continue;
                    BigClip.this.inputStream.read(new byte[offset], 0, offset);
                    BigClip.this.inputStream.reset();
                    bytesRead = BigClip.this.inputStream.read(data, 0, data.length);
                }
                BigClip.this.active = false;
                BigClip.this.countDown = 1;
                BigClip.this.framePosition = 0;
                BigClip.this.inputStream.reset();
                BigClip.this.dataLine.stop();
            }
        };
        this.thread = new Thread(r);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void flush() {
        this.dataLine.flush();
    }

    @Override
    public void drain() {
        this.dataLine.drain();
    }

    @Override
    public void removeLineListener(LineListener listener) {
        this.dataLine.removeLineListener(listener);
    }

    @Override
    public void addLineListener(LineListener listener) {
        this.dataLine.addLineListener(listener);
    }

    @Override
    public Control getControl(Control.Type control) {
        return this.dataLine.getControl(control);
    }

    @Override
    public Control[] getControls() {
        if (this.dataLine == null) {
            return new Control[0];
        }
        return this.dataLine.getControls();
    }

    @Override
    public boolean isControlSupported(Control.Type control) {
        return this.dataLine.isControlSupported(control);
    }

    @Override
    public void close() {
        this.dataLine.close();
    }

    @Override
    public void open() throws LineUnavailableException {
        throw new IllegalArgumentException("illegal call to open() in interface Clip");
    }

    @Override
    public Line.Info getLineInfo() {
        return this.dataLine.getLineInfo();
    }
}

