/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BlendComposite
implements Composite {
    public static final BlendComposite Multiply = new BlendComposite(new Blender(){

        @Override
        protected int blend(int srcA, int srcR, int srcG, int srcB, int dstA, int dstR, int dstG, int dstB, float alpha) {
            return this.compose(srcA + dstA - srcA * dstA / 255, srcR * dstR >> 8, srcG * dstG >> 8, srcB * dstB >> 8, dstA, dstR, dstG, dstB, alpha);
        }
    });
    private final Blender blender;
    private final float alpha;
    private final CompositeContext context = new CompositeContext(){

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            int width = Math.min(src.getWidth(), dstIn.getWidth());
            int height = Math.min(src.getHeight(), dstIn.getHeight());
            int[] srcPixels = new int[width];
            int[] dstPixels = new int[width];
            for (int yy = 0; yy < height; ++yy) {
                src.getDataElements(0, yy, width, 1, srcPixels);
                dstIn.getDataElements(0, yy, width, 1, dstPixels);
                BlendComposite.this.blender.blend(srcPixels, dstPixels, width, BlendComposite.this.alpha);
                dstOut.setDataElements(0, yy, width, 1, dstPixels);
            }
        }

        @Override
        public void dispose() {
        }
    };

    public BlendComposite derive(float alpha) {
        return alpha == this.alpha ? this : new BlendComposite(this.blender, alpha);
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return this.context;
    }

    protected BlendComposite(Blender blender) {
        this(blender, 1.0f);
    }

    protected BlendComposite(Blender blender, float alpha) {
        this.blender = blender;
        this.alpha = alpha;
    }

    protected static abstract class Blender {
        protected Blender() {
        }

        public void blend(int[] srcPixels, int[] dstPixels, int width, float alpha) {
            for (int xx = 0; xx < width; ++xx) {
                int srcARGB = srcPixels[xx];
                int dstARGB = dstPixels[xx];
                int srcA = srcARGB >> 24 & 0xFF;
                int dstA = dstARGB >> 24 & 0xFF;
                int srcR = srcARGB >> 16 & 0xFF;
                int dstR = dstARGB >> 16 & 0xFF;
                int srcG = srcARGB >> 8 & 0xFF;
                int dstG = dstARGB >> 8 & 0xFF;
                int srcB = srcARGB & 0xFF;
                int dstB = dstARGB & 0xFF;
                dstPixels[xx] = this.blend(srcA, srcR, srcG, srcB, dstA, dstR, dstG, dstB, alpha);
            }
        }

        protected abstract int blend(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9);

        protected int compose(int a, int r, int g, int b, int dstA, int dstR, int dstG, int dstB, float alpha) {
            return (0xFF & (int)((float)dstA + (float)(a - dstA) * alpha)) << 24 | (0xFF & (int)((float)dstR + (float)(r - dstR) * alpha)) << 16 | (0xFF & (int)((float)dstG + (float)(g - dstG) * alpha)) << 8 | 0xFF & (int)((float)dstB + (float)(b - dstB) * alpha);
        }
    }
}

