/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import playn.core.Canvas;
import playn.java.BlendComposite;
import playn.java.JavaGradient;
import playn.java.JavaPattern;

class JavaCanvasState {
    private static Clipper NOCLIP = new Clipper(){

        @Override
        public void setClip(Graphics2D gfx) {
            gfx.setClip(null);
        }
    };
    int fillColor;
    int strokeColor;
    JavaGradient fillGradient;
    JavaPattern fillPattern;
    AffineTransform transform;
    float strokeWidth;
    Canvas.LineCap lineCap;
    Canvas.LineJoin lineJoin;
    float miterLimit;
    Clipper clipper;
    Canvas.Composite composite;
    float alpha;

    JavaCanvasState() {
        this(-16777216, -1, null, null, new AffineTransform(), 1.0f, Canvas.LineCap.SQUARE, Canvas.LineJoin.MITER, 10.0f, NOCLIP, Canvas.Composite.SRC_OVER, 1.0f);
    }

    JavaCanvasState(JavaCanvasState toCopy) {
        this(toCopy.fillColor, toCopy.strokeColor, toCopy.fillGradient, toCopy.fillPattern, toCopy.transform, toCopy.strokeWidth, toCopy.lineCap, toCopy.lineJoin, toCopy.miterLimit, toCopy.clipper, toCopy.composite, toCopy.alpha);
    }

    JavaCanvasState(int fillColor, int strokeColor, JavaGradient fillGradient, JavaPattern fillPattern, AffineTransform transform, float strokeWidth, Canvas.LineCap lineCap, Canvas.LineJoin lineJoin, float miterLimit, Clipper clipper, Canvas.Composite composite, float alpha) {
        this.fillColor = fillColor;
        this.strokeColor = strokeColor;
        this.fillGradient = fillGradient;
        this.fillPattern = fillPattern;
        this.transform = transform;
        this.strokeWidth = strokeWidth;
        this.lineCap = lineCap;
        this.lineJoin = lineJoin;
        this.miterLimit = miterLimit;
        this.clipper = clipper;
        this.composite = composite;
        this.alpha = alpha;
    }

    void prepareStroke(Graphics2D gfx) {
        gfx.setStroke(new BasicStroke(this.strokeWidth, this.convertLineCap(), this.convertLineJoin(), this.miterLimit));
        gfx.setColor(JavaCanvasState.convertColor(this.strokeColor));
        this.clipper.setClip(gfx);
        gfx.setComposite(this.convertComposite(this.composite, this.alpha));
    }

    void prepareFill(Graphics2D gfx) {
        if (this.fillGradient != null) {
            gfx.setPaint(this.fillGradient.paint);
        } else if (this.fillPattern != null) {
            TexturePaint paint = this.fillPattern.paint;
            if (paint != null) {
                gfx.setPaint(paint);
            }
        } else {
            gfx.setPaint(JavaCanvasState.convertColor(this.fillColor));
        }
        this.clipper.setClip(gfx);
        gfx.setComposite(this.convertComposite(this.composite, this.alpha));
    }

    static Color convertColor(int color) {
        float a = (float)(color >>> 24) / 255.0f;
        float r = (float)(color >>> 16 & 0xFF) / 255.0f;
        float g = (float)(color >>> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Color(r, g, b, a);
    }

    private Composite convertComposite(Canvas.Composite composite, float alpha) {
        switch (composite) {
            case DST_ATOP: {
                return AlphaComposite.DstAtop.derive(alpha);
            }
            case DST_IN: {
                return AlphaComposite.DstIn.derive(alpha);
            }
            case DST_OUT: {
                return AlphaComposite.DstOut.derive(alpha);
            }
            case DST_OVER: {
                return AlphaComposite.DstOver.derive(alpha);
            }
            case SRC: {
                return AlphaComposite.Src.derive(alpha);
            }
            case SRC_ATOP: {
                return AlphaComposite.SrcAtop.derive(alpha);
            }
            case SRC_IN: {
                return AlphaComposite.SrcIn.derive(alpha);
            }
            case SRC_OUT: {
                return AlphaComposite.SrcOut.derive(alpha);
            }
            case SRC_OVER: {
                return AlphaComposite.SrcOver.derive(alpha);
            }
            case XOR: {
                return AlphaComposite.Xor.derive(alpha);
            }
            case MULTIPLY: {
                return BlendComposite.Multiply.derive(alpha);
            }
        }
        return AlphaComposite.Src.derive(alpha);
    }

    private int convertLineCap() {
        switch (this.lineCap) {
            case BUTT: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
            case SQUARE: {
                return 2;
            }
        }
        return 2;
    }

    private int convertLineJoin() {
        switch (this.lineJoin) {
            case BEVEL: {
                return 2;
            }
            case MITER: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
        }
        return 0;
    }

    public static interface Clipper {
        public void setClip(Graphics2D var1);
    }
}

