/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.Display;
import playn.core.CanvasImage;
import playn.core.Font;
import playn.core.Game;
import playn.core.Gradient;
import playn.core.Platform;
import playn.core.PlayN;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.gl.GL20;
import playn.core.gl.GL20Context;
import playn.core.gl.GLContext;
import playn.core.gl.GraphicsGL;
import playn.core.gl.GroupLayerGL;
import playn.core.gl.Scale;
import playn.java.JavaAssets;
import playn.java.JavaAsyncImage;
import playn.java.JavaCanvasImage;
import playn.java.JavaFont;
import playn.java.JavaGLContext;
import playn.java.JavaGradient;
import playn.java.JavaImage;
import playn.java.JavaPlatform;
import playn.java.JavaStaticImage;
import playn.java.JavaTextLayout;
import pythagoras.f.Point;

public class JavaGraphics
extends GraphicsGL {
    private final GroupLayerGL rootLayer;
    private final GL20Context ctx;
    protected Map<String, Font> _fonts = new HashMap<String, Font>();

    public JavaGraphics(JavaPlatform platform, JavaPlatform.Config config) {
        this.ctx = config.headless ? new GL20Context((Platform)platform, null, config.scaleFactor, false){

            protected void viewWasResized() {
            }
        } : new JavaGLContext(platform, config.scaleFactor, config.width, config.height);
        this.rootLayer = new GroupLayerGL((GLContext)this.ctx);
    }

    public void registerFont(String name, String path) {
        try {
            Font font = Font.createFont(0, ((JavaAssets)PlayN.assets()).getAssetStream(path));
            this._fonts.put(name, font);
        }
        catch (Exception e) {
            PlayN.log().warn("Failed to load font [name=" + name + ", path=" + path + "]", (Throwable)e);
        }
    }

    public void setSize(int width, int height) {
        this.ctx.setSize(width, height);
    }

    public GroupLayerGL rootLayer() {
        return this.rootLayer;
    }

    public CanvasImage createImage(float width, float height) {
        return new JavaCanvasImage((GLContext)this.ctx, width, height);
    }

    public Gradient createLinearGradient(float x0, float y0, float x1, float y1, int[] colors, float[] positions) {
        return JavaGradient.createLinear(x0, y0, x1, y1, positions, colors);
    }

    public Gradient createRadialGradient(float x, float y, float r, int[] colors, float[] positions) {
        return JavaGradient.createRadial(x, y, r, positions, colors);
    }

    public playn.core.Font createFont(String name, Font.Style style, float size) {
        Font jfont = this._fonts.get(name);
        if (jfont == null) {
            jfont = new Font(name, 0, 12);
        }
        return new JavaFont(name, style, size, jfont);
    }

    public TextLayout layoutText(String text, TextFormat format) {
        return new JavaTextLayout(this, text, format);
    }

    public int screenWidth() {
        return Display.getDesktopDisplayMode().getWidth();
    }

    public int screenHeight() {
        return Display.getDesktopDisplayMode().getHeight();
    }

    public GL20 gl20() {
        return this.ctx.gl;
    }

    public GLContext ctx() {
        return this.ctx;
    }

    protected JavaImage createStaticImage(BufferedImage source, Scale scale) {
        return new JavaStaticImage((GLContext)this.ctx, source, scale);
    }

    protected JavaAsyncImage createAsyncImage(float width, float height) {
        return new JavaAsyncImage((GLContext)this.ctx, width, height);
    }

    void init() {
        this.ctx.init();
    }

    void transformMouse(Point point) {
        point.x /= this.ctx.scale.factor;
        point.y /= this.ctx.scale.factor;
    }

    void paint(Game game, float paintAlpha) {
        this.ctx.preparePaint(this.rootLayer);
        game.paint(paintAlpha);
        this.ctx.paintLayers(this.rootLayer);
    }
}

