/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import org.lwjgl.LWJGLException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import playn.core.Events;
import playn.core.Mouse;
import playn.core.MouseImpl;
import playn.core.PlayN;
import playn.java.JavaPlatform;
import playn.java.JavaPointer;
import pythagoras.f.Point;

class JavaMouse
extends MouseImpl {
    private final JavaPlatform platform;

    public JavaMouse(JavaPlatform platform) {
        this.platform = platform;
    }

    public void lock() {
        Mouse.setGrabbed((boolean)true);
    }

    public void unlock() {
        Mouse.setGrabbed((boolean)false);
    }

    public boolean isLocked() {
        return Mouse.isGrabbed();
    }

    public boolean isLockSupported() {
        return true;
    }

    void init() throws LWJGLException {
        Mouse.create();
    }

    void update() {
        JavaPointer pointer = (JavaPointer)PlayN.pointer();
        while (Mouse.next()) {
            double time = Mouse.getEventNanoseconds() / 1000000L;
            int btn = JavaMouse.getButton(Mouse.getEventButton());
            Point m = new Point((float)Mouse.getEventX(), (float)(Display.getHeight() - Mouse.getEventY() - 1));
            this.platform.graphics().transformMouse(m);
            int dx = Mouse.getEventDX();
            int dy = -Mouse.getEventDY();
            if (btn != -1) {
                if (Mouse.getEventButtonState()) {
                    this.onMouseDown(new Mouse.ButtonEvent.Impl((Events.Flags)new Events.Flags.Impl(), time, m.x, m.y, btn));
                    pointer.onMouseDown(time, m.x, m.y);
                    continue;
                }
                this.onMouseUp(new Mouse.ButtonEvent.Impl((Events.Flags)new Events.Flags.Impl(), time, m.x, m.y, btn));
                pointer.onMouseUp(time, m.x, m.y);
                continue;
            }
            if (Mouse.getEventDWheel() != 0) {
                int delta = Mouse.getEventDWheel() > 0 ? -1 : 1;
                this.onMouseWheelScroll(new Mouse.WheelEvent.Impl((Events.Flags)new Events.Flags.Impl(), time, m.x, m.y, (float)delta));
                continue;
            }
            this.onMouseMove(new Mouse.MotionEvent.Impl((Events.Flags)new Events.Flags.Impl(), time, m.x, m.y, (float)dx, (float)dy));
            pointer.onMouseMove(time, m.x, m.y);
        }
    }

    protected static int getButton(int lwjglButton) {
        switch (lwjglButton) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return lwjglButton;
    }
}

