/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import playn.core.BatchImpl;
import playn.core.Storage;
import playn.java.JavaPlatform;

class JavaStorage
implements Storage {
    private final JavaPlatform platform;
    private final File tempFile;
    private final Properties properties;
    private boolean isPersisted = false;

    JavaStorage(JavaPlatform platform, JavaPlatform.Config config) {
        this.platform = platform;
        this.tempFile = new File(new File(System.getProperty("java.io.tmpdir")), config.storageFileName + ".tmp");
        this.properties = this.maybeRetrieveProperties();
    }

    public void setItem(String key, String value) throws RuntimeException {
        this.properties.setProperty(key, value);
        this.maybePersistProperties(this.properties);
    }

    public void removeItem(String key) {
        this.properties.remove(key);
        this.maybePersistProperties(this.properties);
    }

    public String getItem(String key) {
        return this.properties.getProperty(key);
    }

    public Storage.Batch startBatch() {
        return new BatchImpl(this){

            protected void setImpl(String key, String data) {
                JavaStorage.this.properties.setProperty(key, data);
            }

            protected void removeImpl(String key, String data) {
                JavaStorage.this.properties.remove(key);
            }

            protected void onAfterCommit() {
                JavaStorage.this.maybePersistProperties(JavaStorage.this.properties);
            }
        };
    }

    public Iterable<String> keys() {
        return this.properties.stringPropertyNames();
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    private void maybePersistProperties(Properties properties) {
        try {
            properties.store(new FileOutputStream(this.tempFile), null);
            this.isPersisted = true;
        }
        catch (Exception e) {
            this.platform.log().info("Error persisting properties: " + e.getMessage());
            this.isPersisted = false;
        }
    }

    private Properties maybeRetrieveProperties() {
        Properties properties = new Properties();
        if (this.tempFile.exists()) {
            try {
                properties.load(new FileInputStream(this.tempFile));
                this.isPersisted = true;
            }
            catch (Exception e) {
                this.platform.log().info("Error retrieving file: " + e.getMessage());
                this.isPersisted = false;
            }
        } else {
            this.maybePersistProperties(properties);
        }
        return properties;
    }
}

