/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import playn.core.AbstractTextLayout;
import playn.core.Graphics;
import playn.core.TextFormat;
import playn.java.JavaFont;
import playn.java.JavaGraphics;
import pythagoras.f.Rectangle;

class JavaTextLayout
extends AbstractTextLayout {
    private static FontRenderContext dummyFontContext = JavaTextLayout.createDummyFRC();
    private List<TextLayout> layouts = new ArrayList<TextLayout>();
    private final float xAdjust;

    public JavaTextLayout(JavaGraphics gfx, String text, TextFormat format) {
        super((Graphics)gfx, text, format);
        text = text.replace("\r\n", "\n").replace('\r', '\n');
        boolean isEmptyString = text.length() == 0;
        String ltext = isEmptyString ? " " : text;
        AttributedString astring = new AttributedString(ltext);
        if (format.font != null) {
            astring.addAttribute(TextAttribute.FONT, ((JavaFont)format.font).jfont);
        }
        if (format.shouldWrap() || ltext.indexOf(10) != -1) {
            LineBreakMeasurer measurer = new LineBreakMeasurer(astring.getIterator(), dummyFontContext);
            int eol = 10;
            int lastPos = ltext.length();
            while (measurer.getPosition() < lastPos) {
                int nextRet = ltext.indexOf(eol, measurer.getPosition() + 1);
                if (nextRet == -1) {
                    nextRet = lastPos;
                }
                this.layouts.add(measurer.nextLayout(format.wrapWidth, nextRet, false));
            }
        } else {
            this.layouts.add(new TextLayout(astring.getIterator(), dummyFontContext));
        }
        float maxXAdjust = 0.0f;
        float twidth = 0.0f;
        float theight = 0.0f;
        for (TextLayout layout : this.layouts) {
            Rectangle2D bounds = layout.getBounds();
            maxXAdjust = Math.max(maxXAdjust, -Math.min(0.0f, (float)bounds.getX()));
            twidth = Math.max(twidth, JavaTextLayout.getWidth(bounds));
            if (layout != this.layouts.get(0)) {
                theight += layout.getLeading();
            }
            theight += layout.getAscent() + layout.getDescent();
        }
        this.width = isEmptyString ? 0.0f : twidth;
        this.height = theight;
        this.xAdjust = maxXAdjust;
    }

    public float width() {
        return super.width() + this.xAdjust;
    }

    public int lineCount() {
        return this.layouts.size();
    }

    public Rectangle lineBounds(int line) {
        Rectangle2D bounds = this.layouts.get(line).getBounds();
        float lineWidth = JavaTextLayout.getWidth(bounds);
        float x = this.xAdjust + this.format.align.getX(lineWidth, this.width);
        float y = line == 0 ? 0.0f : (float)line * (this.ascent() + this.descent() + this.leading());
        return new Rectangle(x + this.pad, y + this.pad, lineWidth, this.ascent() + this.descent());
    }

    public float ascent() {
        return this.layouts.size() == 0 ? 0.0f : this.layouts.get(0).getAscent();
    }

    public float descent() {
        return this.layouts.size() == 0 ? 0.0f : this.layouts.get(0).getDescent();
    }

    public float leading() {
        return this.layouts.size() == 0 ? 0.0f : this.layouts.get(0).getLeading();
    }

    void stroke(Graphics2D gfx, float x, float y) {
        this.paint(gfx, x + this.pad, y + this.pad, true);
    }

    void fill(Graphics2D gfx, float x, float y) {
        this.paint(gfx, x + this.pad, y + this.pad, false);
    }

    void paint(Graphics2D gfx, float x, float y, boolean stroke) {
        float yoff = y;
        for (TextLayout layout : this.layouts) {
            Rectangle2D bounds = layout.getBounds();
            float sx = x + this.xAdjust + this.format.align.getX(JavaTextLayout.getWidth(bounds), this.width);
            yoff += layout.getAscent();
            if (stroke) {
                gfx.translate(sx, yoff);
                gfx.draw(layout.getOutline(null));
                gfx.translate(-sx, -yoff);
            } else {
                layout.draw(gfx, sx, yoff);
            }
            yoff += layout.getDescent() + layout.getLeading();
        }
    }

    private static float getWidth(Rectangle2D bounds) {
        return (float)(Math.max(0.0, bounds.getX()) + bounds.getWidth());
    }

    private static FontRenderContext createDummyFRC() {
        Graphics2D gfx = new BufferedImage(1, 1, 2).createGraphics();
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return gfx.getFontRenderContext();
    }
}

