/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import playn.core.Net;
import playn.core.Platform;

public class JavaWebSocket
implements Net.WebSocket {
    private final WebSocketClient socket;

    public JavaWebSocket(final Platform platform, String uri, final Net.WebSocket.Listener listener) {
        URI juri = null;
        try {
            juri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.socket = new WebSocketClient(juri){

            public void onMessage(final ByteBuffer buffer) {
                platform.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onDataMessage(buffer);
                    }
                });
            }

            public void onMessage(final String msg) {
                platform.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onTextMessage(msg);
                    }
                });
            }

            public void onError(final Exception e) {
                platform.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onError(e.getMessage());
                    }
                });
            }

            public void onClose(int arg0, String arg1, boolean arg2) {
                platform.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onClose();
                    }
                });
            }

            public void onOpen(ServerHandshake handshake) {
                platform.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onOpen();
                    }
                });
            }
        };
        this.socket.connect();
    }

    public void close() {
        this.socket.close();
    }

    public void send(String data) {
        try {
            this.socket.getConnection().send(data);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void send(ByteBuffer data) {
        try {
            this.socket.getConnection().send(data);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

