/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import playn.core.Canvas;
import playn.core.CanvasImage;
import playn.core.Image;
import playn.core.gl.GLContext;
import playn.core.util.Callback;
import playn.java.JavaCanvas;
import playn.java.JavaImage;
import playn.java.JavaStaticImage;

class JavaCanvasImage
extends JavaImage
implements CanvasImage {
    private final JavaCanvas canvas;

    JavaCanvasImage(GLContext ctx, float width, float height) {
        super(ctx, new BufferedImage(ctx.scale.scaledCeil(width), ctx.scale.scaledCeil(height), 3), ctx.scale);
        Graphics2D gfx = this.img.createGraphics();
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gfx.scale(ctx.scale.factor, ctx.scale.factor);
        this.canvas = new JavaCanvas(gfx, this.width(), this.height());
    }

    public Canvas canvas() {
        return this.canvas;
    }

    public Image snapshot() {
        ColorModel cm = this.img.getColorModel();
        boolean isAlphaPremultiplied = this.img.isAlphaPremultiplied();
        WritableRaster raster = this.img.copyData(null);
        BufferedImage snap = new BufferedImage(cm, raster, isAlphaPremultiplied, null);
        return new JavaStaticImage(this.ctx, snap, this.scale);
    }

    public void addCallback(Callback<? super Image> callback) {
        callback.onSuccess((Object)this);
    }

    public int ensureTexture() {
        if (this.canvas.dirty()) {
            this.canvas.clearDirty();
            this.clearTexture();
        }
        return super.ensureTexture();
    }

    public void setRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        this.img.setRGB(startX, startY, width, height, rgbArray, offset, scanSize);
    }
}

