/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import playn.core.Events;
import playn.core.Key;
import playn.core.Keyboard;
import playn.core.Mouse;
import playn.core.Touch;
import playn.core.TouchImpl;
import playn.java.JavaLWJGLMouse;
import playn.java.JavaMouse;
import playn.java.JavaPlatform;
import pythagoras.f.Point;

public class JavaEmulatedTouch
extends TouchImpl {
    private boolean mouseDown;
    private Point pivot;
    private float x;
    private float y;
    private int currentId;
    private final Key multiTouchKey;
    Keyboard.Listener keyListener = new Keyboard.Adapter(){

        public void onKeyUp(Keyboard.Event event) {
            if (event.key() == JavaEmulatedTouch.this.multiTouchKey) {
                JavaEmulatedTouch.this.pivot = new Point(JavaEmulatedTouch.this.x, JavaEmulatedTouch.this.y);
            }
        }
    };

    public JavaEmulatedTouch(Key multiTouchKey) {
        this.multiTouchKey = multiTouchKey;
    }

    public boolean hasTouch() {
        return true;
    }

    JavaMouse createMouse(JavaPlatform platform) {
        return new JavaLWJGLMouse(platform){

            public boolean hasMouse() {
                return false;
            }

            protected boolean onMouseDown(Mouse.ButtonEvent.Impl event) {
                JavaEmulatedTouch.this.onMouseDown(event.time(), event.x(), event.y());
                return false;
            }

            protected boolean onMouseMove(Mouse.MotionEvent.Impl event) {
                JavaEmulatedTouch.this.onMouseMove(event.time(), event.x(), event.y());
                return false;
            }

            protected boolean onMouseUp(Mouse.ButtonEvent.Impl event) {
                JavaEmulatedTouch.this.onMouseUp(event.time(), event.x(), event.y());
                return false;
            }

            protected boolean onMouseWheelScroll(Mouse.WheelEvent.Impl event) {
                return false;
            }
        };
    }

    void onMouseDown(double time, float x, float y) {
        this.currentId += 2;
        this.onTouchStart(this.toTouches(time, x, y));
        this.mouseDown = true;
    }

    void onMouseUp(double time, float x, float y) {
        this.onTouchEnd(this.toTouches(time, x, y));
        this.mouseDown = false;
        this.pivot = null;
    }

    void onMouseMove(double time, float x, float y) {
        this.x = x;
        this.y = y;
        if (this.mouseDown) {
            this.onTouchMove(this.toTouches(time, x, y));
        }
    }

    Touch.Event.Impl toTouch(double time, float x, float y, int idoff) {
        return new Touch.Event.Impl((Events.Flags)new Events.Flags.Impl(), time, x, y, this.currentId + idoff);
    }

    Touch.Event.Impl[] toTouches(double time, float x, float y) {
        Touch.Event.Impl[] implArray;
        Touch.Event.Impl t = this.toTouch(time, x, y, 0);
        if (this.pivot == null) {
            Touch.Event.Impl[] implArray2 = new Touch.Event.Impl[1];
            implArray = implArray2;
            implArray2[0] = t;
        } else {
            Touch.Event.Impl[] implArray3 = new Touch.Event.Impl[2];
            implArray3[0] = t;
            implArray = implArray3;
            implArray3[1] = this.toTouch(time, 2.0f * this.pivot.x - x, 2.0f * this.pivot.y - y, 1);
        }
        return implArray;
    }
}

