/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.opengl.GL11;
import playn.core.Asserts;
import playn.core.Platform;
import playn.core.gl.GL20;
import playn.core.gl.GL20Context;
import playn.java.JavaGL20;
import playn.java.JavaPlatform;

public class JavaGLContext
extends GL20Context {
    private static final boolean CHECK_ERRORS = Boolean.getBoolean("playn.glerrors");
    private ByteBuffer imgBuf = JavaGLContext.createImageBuffer(1024);

    static BufferedImage convertImage(BufferedImage image) {
        Asserts.checkNotNull((Object)image);
        switch (image.getType()) {
            case 3: {
                return image;
            }
            case 6: {
                image.coerceData(true);
                return image;
            }
        }
        BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 3);
        Graphics g = convertedImage.getGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.drawImage(image, 0, 0, null);
        return convertedImage;
    }

    public JavaGLContext(JavaPlatform platform, float scaleFactor) {
        super((Platform)platform, (GL20)new JavaGL20(), scaleFactor, CHECK_ERRORS);
    }

    void updateTexture(int tex, BufferedImage image) {
        int type;
        int format;
        ByteBuffer bbuf;
        image = JavaGLContext.convertImage(image);
        DataBuffer dbuf = image.getRaster().getDataBuffer();
        if (image.getType() == 3) {
            DataBufferInt ibuf = (DataBufferInt)dbuf;
            bbuf = this.checkGetImageBuffer(ibuf.getSize() * 4);
            bbuf.asIntBuffer().put(ibuf.getData());
            bbuf.flip();
            format = 32993;
            type = 33639;
        } else if (image.getType() == 6) {
            DataBufferByte dbbuf = (DataBufferByte)dbuf;
            bbuf = this.checkGetImageBuffer(dbbuf.getSize());
            bbuf.put(dbbuf.getData());
            bbuf.flip();
            format = 6408;
            type = 32821;
        } else {
            throw new RuntimeException("Image type wasn't converted to usable: " + image.getType());
        }
        this.bindTexture(tex);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)format, (int)type, (ByteBuffer)bbuf);
        this.checkGLError("updateTexture");
    }

    private ByteBuffer checkGetImageBuffer(int byteSize) {
        if (this.imgBuf.capacity() >= byteSize) {
            this.imgBuf.clear();
        } else {
            this.imgBuf = JavaGLContext.createImageBuffer(byteSize);
        }
        return this.imgBuf;
    }

    private static ByteBuffer createImageBuffer(int byteSize) {
        return ByteBuffer.allocateDirect(byteSize).order(ByteOrder.nativeOrder());
    }
}

