/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import playn.core.Gradient;

class JavaGradient
implements Gradient {
    Paint paint;

    static JavaGradient createLinear(float x0, float y0, float x1, float y1, float[] positions, int[] colors) {
        Point2D.Float start = new Point2D.Float(x0, y0);
        Point2D.Float end = new Point2D.Float(x1, y1);
        Color[] javaColors = JavaGradient.convertColors(colors);
        LinearGradientPaint p = new LinearGradientPaint(start, end, positions, javaColors);
        return new JavaGradient(p);
    }

    static JavaGradient createRadial(float x, float y, float r, float[] positions, int[] colors) {
        Point2D.Float center = new Point2D.Float(x, y);
        RadialGradientPaint p = new RadialGradientPaint(center, r, positions, JavaGradient.convertColors(colors));
        return new JavaGradient(p);
    }

    private static Color[] convertColors(int[] colors) {
        Color[] javaColors = new Color[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            javaColors[i] = new Color(colors[i], true);
        }
        return javaColors;
    }

    private JavaGradient(Paint paint) {
        this.paint = paint;
    }
}

