/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import playn.core.Events;
import playn.core.Key;
import playn.core.Keyboard;
import playn.core.Touch;
import playn.java.JavaEmulatedTouch;

public abstract class JavaKeyboard
implements Keyboard {
    private Keyboard.Listener[] listeners = new Keyboard.Listener[]{null};
    private final List<Queued<?>> queue = Collections.synchronizedList(new ArrayList());
    protected final Dispatcher<Keyboard.Event> down = new Dispatcher<Keyboard.Event>(){

        @Override
        public void send(Keyboard.Listener l, Keyboard.Event e) {
            l.onKeyDown(e);
        }
    };
    protected final Dispatcher<Keyboard.Event> up = new Dispatcher<Keyboard.Event>(){

        @Override
        public void send(Keyboard.Listener l, Keyboard.Event e) {
            l.onKeyUp(e);
        }
    };
    protected final Dispatcher<Keyboard.TypedEvent> typed = new Dispatcher<Keyboard.TypedEvent>(){

        @Override
        public void send(Keyboard.Listener l, Keyboard.TypedEvent e) {
            l.onKeyTyped(e);
        }
    };

    public void post(Key key, boolean pressed, char typedCh) {
        this.queue.add(key == null ? new Queued(this, (Events.Input)new Keyboard.TypedEvent.Impl((Events.Flags)new Events.Flags.Impl(), 0.0, typedCh), this.typed) : new Queued(this, (Events.Input)new Keyboard.Event.Impl((Events.Flags)new Events.Flags.Impl(), 0.0, key), pressed ? this.down : this.up));
    }

    public void setListener(Keyboard.Listener listener) {
        this.listeners[0] = listener;
    }

    public boolean hasHardwareKeyboard() {
        return true;
    }

    void init(Touch touch) {
        if (touch instanceof JavaEmulatedTouch) {
            this.listeners = new Keyboard.Listener[]{this.listeners[0], ((JavaEmulatedTouch)touch).keyListener};
        }
    }

    void update() {
        while (!this.queue.isEmpty()) {
            this.queue.remove(0).dispatch();
        }
    }

    protected <E extends Events.Input> void dispatch(E e, Dispatcher<E> d) {
        for (Keyboard.Listener l : this.listeners) {
            if (l == null) continue;
            d.send(l, e);
        }
    }

    protected static class Queued<E extends Events.Input> {
        final E event;
        final Dispatcher<E> dispatcher;
        final /* synthetic */ JavaKeyboard this$0;

        Queued(E event, Dispatcher<E> dispatcher) {
            this.this$0 = var1_1;
            this.event = event;
            this.dispatcher = dispatcher;
        }

        void dispatch() {
            this.this$0.dispatch(this.event, this.dispatcher);
        }
    }

    protected static interface Dispatcher<E extends Events.Input> {
        public void send(Keyboard.Listener var1, E var2);
    }
}

