/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import org.lwjgl.LWJGLException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import playn.java.JavaMouse;
import playn.java.JavaPlatform;
import pythagoras.f.Point;

class JavaLWJGLMouse
extends JavaMouse {
    public JavaLWJGLMouse(JavaPlatform platform) {
        super(platform);
    }

    public void lock() {
        Mouse.setGrabbed((boolean)true);
    }

    public void unlock() {
        Mouse.setGrabbed((boolean)false);
    }

    public boolean isLocked() {
        return Mouse.isGrabbed();
    }

    public boolean isLockSupported() {
        return true;
    }

    @Override
    void init() {
        try {
            Mouse.create();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void update() {
        while (Mouse.next()) {
            double time = Mouse.getEventNanoseconds() / 1000000L;
            int btn = JavaLWJGLMouse.getButton(Mouse.getEventButton());
            Point m = new Point((float)Mouse.getEventX(), (float)(Display.getHeight() - Mouse.getEventY() - 1));
            this.platform.graphics().transformMouse(m);
            int dx = Mouse.getEventDX();
            int dy = -Mouse.getEventDY();
            if (btn != -1) {
                if (Mouse.getEventButtonState()) {
                    this.onMouseDown(time, m.x, m.y, btn);
                    continue;
                }
                this.onMouseUp(time, m.x, m.y, btn);
                continue;
            }
            if (Mouse.getEventDWheel() != 0) {
                int delta = Mouse.getEventDWheel() > 0 ? -1 : 1;
                this.onMouseWheelScroll(time, m.x, m.y, delta);
                continue;
            }
            this.onMouseMove(time, m.x, m.y, dx, dy);
        }
    }

    private static int getButton(int lwjglButton) {
        switch (lwjglButton) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return lwjglButton;
    }
}

