/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import playn.core.Graphics;
import playn.core.PaddedTextLayout;
import playn.core.TextFormat;
import playn.java.JavaCanvas;
import playn.java.JavaFont;
import playn.java.JavaGraphics;
import pythagoras.f.IRectangle;
import pythagoras.f.Rectangle;

class OldJavaTextLayout
extends PaddedTextLayout
implements JavaCanvas.Drawable {
    private List<TextLayout> layouts = new ArrayList<TextLayout>();
    private final Rectangle bounds;
    private final float xAdjust;

    public OldJavaTextLayout(JavaGraphics gfx, String text, TextFormat format) {
        super((Graphics)gfx, text, format);
        FontRenderContext frc;
        text = text.replace("\r\n", "\n").replace('\r', '\n');
        boolean isEmptyString = text.length() == 0;
        String ltext = isEmptyString ? " " : text;
        AttributedString astring = new AttributedString(ltext);
        if (format.font != null) {
            astring.addAttribute(TextAttribute.FONT, ((JavaFont)format.font).jfont);
        }
        FontRenderContext fontRenderContext = frc = format.antialias ? gfx.aaFontContext : gfx.aFontContext;
        if (format.shouldWrap() || ltext.indexOf(10) != -1) {
            LineBreakMeasurer measurer = new LineBreakMeasurer(astring.getIterator(), frc);
            int eol = 10;
            int lastPos = ltext.length();
            while (measurer.getPosition() < lastPos) {
                int nextRet = ltext.indexOf(eol, measurer.getPosition() + 1);
                if (nextRet == -1) {
                    nextRet = lastPos;
                }
                this.layouts.add(measurer.nextLayout(format.wrapWidth, nextRet, false));
            }
        } else {
            this.layouts.add(new TextLayout(astring.getIterator(), frc));
        }
        float maxXAdjust = 0.0f;
        float twidth = 0.0f;
        float theight = 0.0f;
        for (TextLayout layout : this.layouts) {
            Rectangle2D bounds = layout.getBounds();
            maxXAdjust = Math.max(maxXAdjust, -Math.min(0.0f, (float)bounds.getX()));
            twidth = Math.max(twidth, OldJavaTextLayout.getWidth(bounds));
            if (layout != this.layouts.get(0)) {
                theight += layout.getLeading();
            }
            theight += layout.getAscent() + layout.getDescent();
        }
        this.width = isEmptyString ? 0.0f : twidth;
        this.height = theight;
        this.xAdjust = maxXAdjust;
        this.bounds = new Rectangle(0.0f, 0.0f, this.width, this.height);
    }

    public float width() {
        return super.width() + this.xAdjust;
    }

    public IRectangle bounds() {
        return this.bounds;
    }

    @Deprecated
    public int lineCount() {
        return this.layouts.size();
    }

    @Deprecated
    public Rectangle lineBounds(int line) {
        Rectangle2D bounds = this.layouts.get(line).getBounds();
        float lineWidth = OldJavaTextLayout.getWidth(bounds);
        float x = this.xAdjust + this.format.align.getX(lineWidth, this.width);
        float y = line == 0 ? 0.0f : (float)line * (this.ascent() + this.descent() + this.leading());
        return new Rectangle(x + this.pad, y + this.pad, lineWidth, this.ascent() + this.descent());
    }

    public float ascent() {
        return this.layouts.size() == 0 ? 0.0f : this.layouts.get(0).getAscent();
    }

    public float descent() {
        return this.layouts.size() == 0 ? 0.0f : this.layouts.get(0).getDescent();
    }

    public float leading() {
        return this.layouts.size() == 0 ? 0.0f : this.layouts.get(0).getLeading();
    }

    @Override
    public void stroke(Graphics2D gfx, float x, float y) {
        this.paint(gfx, x + this.pad, y + this.pad, true);
    }

    @Override
    public void fill(Graphics2D gfx, float x, float y) {
        this.paint(gfx, x + this.pad, y + this.pad, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics2D gfx, float x, float y, boolean stroke) {
        float yoff = y;
        Object ohint = gfx.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        try {
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.format.antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            for (TextLayout layout : this.layouts) {
                Rectangle2D bounds = layout.getBounds();
                float sx = x + this.xAdjust + this.format.align.getX(OldJavaTextLayout.getWidth(bounds), this.width);
                yoff += layout.getAscent();
                if (stroke) {
                    gfx.translate(sx, yoff);
                    gfx.draw(layout.getOutline(null));
                    gfx.translate(-sx, -yoff);
                } else {
                    layout.draw(gfx, sx, yoff);
                }
                yoff += layout.getDescent() + layout.getLeading();
            }
        }
        finally {
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, ohint);
        }
    }

    private static float getWidth(Rectangle2D bounds) {
        return (float)(Math.max(0.0, bounds.getX()) + bounds.getWidth());
    }
}

