/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import playn.core.AbstractAssets;
import playn.core.AbstractPlatform;
import playn.core.AsyncImage;
import playn.core.Image;
import playn.core.Sound;
import playn.core.gl.Scale;
import playn.java.JavaAsyncImage;
import playn.java.JavaGLContext;
import playn.java.JavaPlatform;
import pythagoras.f.MathUtil;

public class JavaAssets
extends AbstractAssets<BufferedImage> {
    private final JavaPlatform platform;
    private File[] directories = new File[0];
    private String pathPrefix = "assets/";
    private Scale assetScale = null;
    protected static final String[] SUFFIXES = new String[]{".wav", ".mp3"};

    public JavaAssets(JavaPlatform platform) {
        super((AbstractPlatform)platform);
        this.platform = platform;
    }

    public void setPathPrefix(String prefix) {
        if (prefix.startsWith("/") || prefix.endsWith("/")) {
            throw new IllegalArgumentException("Prefix must not start or end with '/'.");
        }
        this.pathPrefix = prefix.length() == 0 ? prefix : prefix + "/";
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void addDirectory(File dir) {
        File[] ndirs = new File[this.directories.length + 1];
        System.arraycopy(this.directories, 0, ndirs, 0, this.directories.length);
        ndirs[ndirs.length - 1] = dir;
        this.directories = ndirs;
    }

    public void setAssetScale(float scaleFactor) {
        this.assetScale = new Scale(scaleFactor);
    }

    public Image getRemoteImage(final String url, float width, float height) {
        final JavaAsyncImage image = this.platform.graphics().createAsyncImage(width, height);
        this.platform.invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    JavaAssets.this.setImageLater(image, ImageIO.read(new URL(url)), Scale.ONE);
                }
                catch (Exception error) {
                    JavaAssets.this.setErrorLater(image, error);
                }
            }
        });
        return image;
    }

    public Sound getSound(String path) {
        return this.getSound(path, false);
    }

    public Sound getMusic(String path) {
        return this.getSound(path, true);
    }

    public String getTextSync(String path) throws Exception {
        return this.requireResource(path).readString();
    }

    public byte[] getBytesSync(String path) throws Exception {
        return this.requireResource(path).readBytes();
    }

    protected Image createStaticImage(BufferedImage bufimg, Scale scale) {
        return this.platform.graphics().createStaticImage(bufimg, scale);
    }

    protected AsyncImage<BufferedImage> createAsyncImage(float width, float height) {
        return this.platform.graphics().createAsyncImage(width, height);
    }

    protected Image loadImage(String fullPath, AbstractAssets.ImageReceiver<BufferedImage> recv) {
        Exception error = null;
        for (Scale.ScaledResource rsrc : this.assetScale().getScaledResources(fullPath)) {
            try {
                BufferedImage convertedImage;
                BufferedImage image = this.requireResource(rsrc.path).readImage();
                Scale viewScale = this.platform.graphics().ctx().scale;
                Scale imageScale = rsrc.scale;
                float viewImageRatio = viewScale.factor / imageScale.factor;
                if (viewImageRatio < 1.0f) {
                    image = this.scaleImage(image, viewImageRatio);
                    imageScale = viewScale;
                }
                if (this.platform.convertImagesOnLoad && (convertedImage = JavaGLContext.convertImage(image)) != image) {
                    this.platform.log().debug("Converted image: " + fullPath + " [type=" + image.getType() + "]");
                    image = convertedImage;
                }
                return recv.imageLoaded((Object)image, imageScale);
            }
            catch (FileNotFoundException fnfe) {
                error = fnfe;
            }
            catch (Exception e) {
                error = e;
                break;
            }
        }
        this.platform.log().warn("Could not load image: " + fullPath + " [error=" + error + "]");
        return recv.loadFailed((Throwable)(error != null ? error : new FileNotFoundException(fullPath)));
    }

    protected Sound getSound(String path, boolean music) {
        Exception err = null;
        for (String suff : SUFFIXES) {
            String soundPath = path + suff;
            try {
                return this.platform.audio().createSound(this.requireResource(soundPath), music);
            }
            catch (Exception e) {
                err = e;
            }
        }
        this.platform.log().warn("Sound load error " + path + ": " + err);
        return new Sound.Error(err);
    }

    protected Resource requireResource(String path) throws IOException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.pathPrefix + path);
        if (url != null) {
            return url.getProtocol().equals("file") ? new FileResource(new File(url.getPath())) : new URLResource(url);
        }
        for (File dir : this.directories) {
            File f = new File(dir, path).getCanonicalFile();
            if (!f.exists()) continue;
            return new FileResource(f);
        }
        throw new FileNotFoundException(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] toByteArray(InputStream in) throws IOException {
        try {
            byte[] buffer = new byte[512];
            int size = 0;
            int read = 0;
            while ((read = in.read(buffer, size, buffer.length - size)) > 0) {
                if ((size += read) != buffer.length) continue;
                buffer = Arrays.copyOf(buffer, size * 2);
            }
            if (size < buffer.length) {
                buffer = Arrays.copyOf(buffer, size);
            }
            byte[] byArray = buffer;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    protected BufferedImage scaleImage(BufferedImage image, float viewImageRatio) {
        int swidth = MathUtil.iceil((float)(viewImageRatio * (float)image.getWidth()));
        int sheight = MathUtil.iceil((float)(viewImageRatio * (float)image.getHeight()));
        BufferedImage scaled = new BufferedImage(swidth, sheight, 3);
        Graphics2D gfx = scaled.createGraphics();
        gfx.drawImage(image.getScaledInstance(swidth, sheight, 4), 0, 0, null);
        gfx.dispose();
        return scaled;
    }

    protected Scale assetScale() {
        return this.assetScale != null ? this.assetScale : this.platform.graphics().ctx().scale;
    }

    protected static class FileResource
    extends Resource {
        public final File file;

        public FileResource(File file) {
            this.file = file;
        }

        @Override
        public InputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public BufferedImage readImage() throws IOException {
            return ImageIO.read(this.file);
        }

        @Override
        public AudioInputStream openAudioStream() throws Exception {
            return AudioSystem.getAudioInputStream(this.file);
        }

        @Override
        public Font createFont() throws Exception {
            return Font.createFont(0, this.file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] readBytes() throws IOException {
            InputStream in = this.openStream();
            try {
                byte[] buffer = new byte[(int)this.file.length()];
                in.read(buffer);
                byte[] byArray = buffer;
                return byArray;
            }
            finally {
                in.close();
            }
        }
    }

    protected static class URLResource
    extends Resource {
        public final URL url;

        public URLResource(URL url) {
            this.url = url;
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.url.openStream();
        }

        @Override
        public BufferedImage readImage() throws IOException {
            return ImageIO.read(this.url);
        }
    }

    static abstract class Resource {
        Resource() {
        }

        public abstract BufferedImage readImage() throws IOException;

        public abstract InputStream openStream() throws IOException;

        public AudioInputStream openAudioStream() throws Exception {
            return AudioSystem.getAudioInputStream(this.openStream());
        }

        public Font createFont() throws Exception {
            return Font.createFont(0, this.openStream());
        }

        public byte[] readBytes() throws IOException {
            return JavaAssets.toByteArray(this.openStream());
        }

        public String readString() throws Exception {
            return new String(this.readBytes(), "UTF-8");
        }
    }
}

