/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import playn.core.AbstractPlatform;
import playn.core.CanvasImage;
import playn.core.Font;
import playn.core.Gradient;
import playn.core.PlayN;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.TextWrap;
import playn.core.gl.GL20;
import playn.core.gl.GL20Context;
import playn.core.gl.GLContext;
import playn.core.gl.GraphicsGL;
import playn.core.gl.GroupLayerGL;
import playn.core.gl.Scale;
import playn.java.JavaAssets;
import playn.java.JavaAsyncImage;
import playn.java.JavaCanvasImage;
import playn.java.JavaFont;
import playn.java.JavaGLContext;
import playn.java.JavaGradient;
import playn.java.JavaImage;
import playn.java.JavaPlatform;
import playn.java.JavaStaticImage;
import playn.java.JavaTextLayout;
import pythagoras.f.Point;

public class JavaGraphics
extends GraphicsGL {
    protected final JavaPlatform platform;
    protected final GL20Context ctx;
    protected final GroupLayerGL rootLayer;
    final FontRenderContext aaFontContext;
    final FontRenderContext aFontContext;
    protected Map<String, Font> _fonts = new HashMap<String, Font>();

    public JavaGraphics(JavaPlatform platform, JavaPlatform.Config config) {
        this.platform = platform;
        this.ctx = config.headless ? new GL20Context((AbstractPlatform)platform, null, config.scaleFactor, false) : new JavaGLContext(platform, config.scaleFactor);
        this.rootLayer = new GroupLayerGL((GLContext)this.ctx);
        Graphics2D aaGfx = new BufferedImage(1, 1, 2).createGraphics();
        aaGfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.aaFontContext = aaGfx.getFontRenderContext();
        Graphics2D aGfx = new BufferedImage(1, 1, 2).createGraphics();
        aGfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.aFontContext = aGfx.getFontRenderContext();
        if (!config.headless) {
            this.setDisplayMode(this.ctx.scale.scaledCeil((float)config.width), this.ctx.scale.scaledCeil((float)config.height), config.fullscreen);
        }
    }

    public void registerFont(String name, String path) {
        try {
            this._fonts.put(name, ((JavaAssets)PlayN.assets()).requireResource(path).createFont());
        }
        catch (Exception e) {
            this.platform.reportError("Failed to load font [name=" + name + ", path=" + path + "]", e);
        }
    }

    public void setSize(int width, int height, boolean fullscreen) {
        int swidth = this.ctx.scale.scaledCeil((float)width);
        int sheight = this.ctx.scale.scaledCeil((float)height);
        this.setDisplayMode(swidth, sheight, fullscreen);
        this.ctx.setSize(width, height);
    }

    protected void setDisplayMode(int width, int height, boolean fullscreen) {
        try {
            DisplayMode mode = Display.getDisplayMode();
            if (fullscreen == Display.isFullscreen() && mode.getWidth() == width && mode.getHeight() == height) {
                return;
            }
            if (fullscreen) {
                DisplayMode matching = null;
                for (DisplayMode test : Display.getAvailableDisplayModes()) {
                    if (test.getWidth() != width || test.getHeight() != height || !test.isFullscreenCapable()) continue;
                    matching = test;
                }
                if (matching == null) {
                    this.platform.log().info("Could not find a matching fullscreen mode, available: " + Arrays.asList(Display.getAvailableDisplayModes()));
                } else {
                    mode = matching;
                }
            } else {
                mode = new DisplayMode(width, height);
            }
            this.platform.log().debug("Updating display mode: " + mode + ", fullscreen: " + fullscreen);
            if (fullscreen) {
                Display.setDisplayModeAndFullscreen((DisplayMode)mode);
            } else {
                Display.setDisplayMode((DisplayMode)mode);
            }
        }
        catch (LWJGLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public GroupLayerGL rootLayer() {
        return this.rootLayer;
    }

    public CanvasImage createImage(float width, float height) {
        return new JavaCanvasImage((GLContext)this.ctx, width, height);
    }

    public Gradient createLinearGradient(float x0, float y0, float x1, float y1, int[] colors, float[] positions) {
        return JavaGradient.createLinear(x0, y0, x1, y1, positions, colors);
    }

    public Gradient createRadialGradient(float x, float y, float r, int[] colors, float[] positions) {
        return JavaGradient.createRadial(x, y, r, positions, colors);
    }

    public playn.core.Font createFont(String name, Font.Style style, float size) {
        Font jfont = this._fonts.get(name);
        if (jfont == null) {
            jfont = new Font(name, 0, 12);
        }
        return new JavaFont(this, name, style, size, jfont);
    }

    public TextLayout layoutText(String text, TextFormat format) {
        return JavaTextLayout.layoutText(this, text, format);
    }

    public TextLayout[] layoutText(String text, TextFormat format, TextWrap wrap) {
        return JavaTextLayout.layoutText(this, text, format, wrap);
    }

    public int screenWidth() {
        return this.ctx.scale.invScaledFloor((float)Display.getDesktopDisplayMode().getWidth());
    }

    public int screenHeight() {
        return this.ctx.scale.invScaledFloor((float)Display.getDesktopDisplayMode().getHeight());
    }

    public GL20 gl20() {
        return this.ctx.gl;
    }

    public GL20Context ctx() {
        return this.ctx;
    }

    protected JavaImage createStaticImage(BufferedImage source, Scale scale) {
        return new JavaStaticImage((GLContext)this.ctx, source, scale);
    }

    protected JavaAsyncImage createAsyncImage(float width, float height) {
        return new JavaAsyncImage((GLContext)this.ctx, width, height);
    }

    protected void init() {
        DisplayMode mode = Display.getDisplayMode();
        this.ctx.setSize(this.ctx.scale.invScaledFloor((float)mode.getWidth()), this.ctx.scale.invScaledFloor((float)mode.getHeight()));
        this.ctx.init();
    }

    protected void paint() {
        this.ctx.paint(this.rootLayer);
    }

    Point transformMouse(Point point) {
        point.x /= this.ctx.scale.factor;
        point.y /= this.ctx.scale.factor;
        return point;
    }
}

