/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import playn.core.Image;
import playn.core.Pattern;
import playn.core.gl.AbstractImageGL;
import playn.core.gl.GLContext;
import playn.core.gl.ImageGL;
import playn.core.gl.Scale;
import playn.java.JavaBitmapTransformer;
import playn.java.JavaGLContext;
import playn.java.JavaPattern;
import playn.java.JavaStaticImage;
import pythagoras.f.MathUtil;

public abstract class JavaImage
extends ImageGL<Graphics2D> {
    protected BufferedImage img;

    public JavaImage(GLContext ctx, BufferedImage img, Scale scale) {
        super(ctx, scale);
        this.img = img;
    }

    public BufferedImage bufferedImage() {
        return this.img;
    }

    public float width() {
        return this.scale.invScaled((float)this.img.getWidth());
    }

    public float height() {
        return this.scale.invScaled((float)this.img.getHeight());
    }

    public boolean isReady() {
        return this.img != null;
    }

    public Pattern toPattern() {
        assert (this.isReady()) : "Cannot generate a pattern from unready image.";
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, this.width(), this.height());
        return new JavaPattern((AbstractImageGL<?>)this, this.repeatX, this.repeatY, new TexturePaint(this.img, rect));
    }

    public void getRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        this.img.getRGB(startX, startY, width, height, rgbArray, offset, scanSize);
    }

    public Image transform(Image.BitmapTransformer xform) {
        return new JavaStaticImage(this.ctx, ((JavaBitmapTransformer)xform).transform(this.img), this.scale);
    }

    public void draw(Graphics2D gfx, float x, float y, float w, float h) {
        AffineTransform tx = new AffineTransform(w / (float)this.img.getWidth(), 0.0f, 0.0f, h / (float)this.img.getHeight(), x, y);
        gfx.drawImage(this.img, tx, null);
    }

    public void draw(Graphics2D gfx, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        float scaleX = dw / (sw *= this.scale.factor);
        float scaleY = dh / (sh *= this.scale.factor);
        Shape oclip = gfx.getClip();
        gfx.clipRect(MathUtil.ifloor((float)dx), MathUtil.ifloor((float)dy), MathUtil.iceil((float)dw), MathUtil.iceil((float)dh));
        gfx.drawImage(this.img, new AffineTransform(scaleX, 0.0f, 0.0f, scaleY, dx - (sx *= this.scale.factor) * scaleX, dy - (sy *= this.scale.factor) * scaleY), null);
        gfx.setClip(oclip);
    }

    protected Pattern toSubPattern(AbstractImageGL<?> image, boolean repeatX, boolean repeatY, float x, float y, float width, float height) {
        assert (this.isReady()) : "Cannot generate a pattern from unready image.";
        BufferedImage subImage = this.img.getSubimage(this.scale.scaledFloor(x), this.scale.scaledFloor(y), this.scale.scaledCeil(width), this.scale.scaledCeil(height));
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, width, height);
        return new JavaPattern(image, repeatX, repeatY, new TexturePaint(subImage, rect));
    }

    protected void updateTexture(int tex) {
        assert (this.img != null);
        ((JavaGLContext)this.ctx).updateTexture(tex, this.img);
    }
}

