/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import playn.core.Events;
import playn.core.Mouse;
import playn.core.MouseImpl;
import playn.java.JavaPlatform;
import playn.java.JavaPointer;

abstract class JavaMouse
extends MouseImpl {
    protected final JavaPlatform platform;
    private final JavaPointer pointer;

    public JavaMouse(JavaPlatform platform) {
        this.platform = platform;
        this.pointer = platform.pointer();
        assert (this.pointer != null);
    }

    abstract void init();

    abstract void update();

    protected void onMouseDown(double time, float x, float y, int btn) {
        this.onMouseDown(new Mouse.ButtonEvent.Impl((Events.Flags)new Events.Flags.Impl(), time, x, y, btn));
        if (btn == 0) {
            this.pointer.onMouseDown(time, x, y);
        }
    }

    protected void onMouseUp(double time, float x, float y, int btn) {
        this.onMouseUp(new Mouse.ButtonEvent.Impl((Events.Flags)new Events.Flags.Impl(), time, x, y, btn));
        if (btn == 0) {
            this.pointer.onMouseUp(time, x, y);
        }
    }

    protected void onMouseMove(double time, float x, float y, float dx, float dy) {
        this.onMouseMove(new Mouse.MotionEvent.Impl((Events.Flags)new Events.Flags.Impl(), time, x, y, dx, dy));
        this.pointer.onMouseMove(time, x, y);
    }

    protected void onMouseWheelScroll(double time, float x, float y, int delta) {
        this.onMouseWheelScroll(new Mouse.WheelEvent.Impl((Events.Flags)new Events.Flags.Impl(), time, x, y, (float)delta));
    }
}

