/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import playn.core.AbstractPlatform;
import playn.core.Net;
import playn.core.NetImpl;
import playn.core.Platform;
import playn.core.util.Callback;
import playn.java.JavaAssets;
import playn.java.JavaPlatform;
import playn.java.JavaWebSocket;

public class JavaNet
extends NetImpl {
    private final int draft;

    public JavaNet(JavaPlatform platform, int draft) {
        super((AbstractPlatform)platform);
        this.draft = draft;
    }

    public Net.WebSocket createWebSocket(String url, Net.WebSocket.Listener listener) {
        return new JavaWebSocket((Platform)this.platform, url, listener, this.draft);
    }

    protected void execute(final NetImpl.BuilderImpl req, final Callback<Net.Response> callback) {
        this.platform.invokeAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    URL url = new URL(JavaNet.this.canonicalizeUrl(req.url));
                    final HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    for (NetImpl.Header header : req.headers) {
                        conn.setRequestProperty(header.name, header.value);
                    }
                    conn.setRequestMethod(req.method());
                    if (req.isPost()) {
                        conn.setDoOutput(true);
                        conn.setDoInput(true);
                        conn.setAllowUserInteraction(false);
                        conn.setRequestProperty("Content-type", req.contentType());
                        conn.connect();
                        conn.getOutputStream().write(req.payloadString == null ? req.payloadBytes : req.payloadString.getBytes("UTF-8"));
                        conn.getOutputStream().close();
                    }
                    try {
                        int code = conn.getResponseCode();
                        InputStream stream = code >= 400 ? conn.getErrorStream() : conn.getInputStream();
                        byte[] payload = stream == null ? new byte[]{} : JavaAssets.toByteArray(stream);
                        String encoding = conn.getContentEncoding();
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        JavaNet.this.platform.notifySuccess(callback, (Object)new NetImpl.BinaryResponse(code, payload, encoding){

                            protected Map<String, List<String>> extractHeaders() {
                                return conn.getHeaderFields();
                            }
                        });
                    }
                    finally {
                        conn.disconnect();
                    }
                }
                catch (MalformedURLException e) {
                    JavaNet.this.platform.notifyFailure(callback, (Throwable)e);
                }
                catch (IOException e) {
                    JavaNet.this.platform.notifyFailure(callback, (Throwable)e);
                }
            }

            public String toString() {
                return "JavaNet." + req.method().toLowerCase() + "(" + req.url + ")";
            }
        });
    }

    private String canonicalizeUrl(String url) {
        if (!url.startsWith("http")) {
            return "http://" + this.server() + url;
        }
        return url;
    }

    private String server() {
        return "127.0.0.1:8080";
    }
}

